/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.ppmodel.extensions;

import com.google.common.collect.Iterators;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import org.eclipse.set.basis.graph.DirectedElement;
import org.eclipse.set.model.planpro.Basisobjekte.Identitaet_TypeClass;
import org.eclipse.set.model.planpro.Geodaten.GEO_Kante;
import org.eclipse.set.model.planpro.Geodaten.GEO_Knoten;
import org.eclipse.set.model.planpro.Geodaten.TOP_Kante;
import org.eclipse.set.model.planpro.Geodaten.TOP_Knoten;
import org.eclipse.set.model.planpro.PlanPro.PlanPro_Schnittstelle;
import org.eclipse.set.ppmodel.extensions.GeoKanteExtensions;
import org.eclipse.set.ppmodel.extensions.TopKanteExtensions;
import org.eclipse.set.ppmodel.extensions.TopKnotenExtensions;
import org.eclipse.set.ppmodel.extensions.utils.DirectedTopKante;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.InputOutput;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;

public class PlanProSchnittstelleDebugExtensions {
    public static void validateTopKanten(PlanPro_Schnittstelle planning) {
        Statistics statistics = new Statistics();
        try {
            Procedures.Procedure1 _function = it -> PlanProSchnittstelleDebugExtensions.validate(it, statistics);
            IteratorExtensions.forEach((Iterator)Iterators.filter((Iterator)planning.eAllContents(), TOP_Kante.class), (Procedures.Procedure1)_function);
            InputOutput.println();
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("Total edges = ");
            _builder.append((Object)statistics.total);
            _builder.append(" failed to cover TOP-Kante = ");
            _builder.append((Object)statistics.topCoverfailed);
            InputOutput.println((Object)_builder.toString());
        }
        catch (Throwable _t) {
            if (_t instanceof Exception) {
                StringConcatenation _builder_1 = new StringConcatenation();
                _builder_1.append("validateTopKanten failed with exception");
                InputOutput.println((Object)_builder_1.toString());
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
    }

    private static void validate(TOP_Kante edge, Statistics statistics) {
        ++statistics.total;
        InputOutput.println();
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("Analysis of TOP_Kante with identitaet=");
        Identitaet_TypeClass _identitaet = null;
        if (edge != null) {
            _identitaet = edge.getIdentitaet();
        }
        String _wert = null;
        if (_identitaet != null) {
            _wert = _identitaet.getWert();
        }
        _builder.append(_wert);
        InputOutput.println((Object)_builder.toString());
        TOP_Knoten _tOPKnotenA = null;
        if (edge != null) {
            _tOPKnotenA = TopKanteExtensions.getTOPKnotenA(edge);
        }
        TOP_Knoten topKnotenA = _tOPKnotenA;
        TOP_Knoten _tOPKnotenB = null;
        if (edge != null) {
            _tOPKnotenB = TopKanteExtensions.getTOPKnotenB(edge);
        }
        TOP_Knoten topKnotenB = _tOPKnotenB;
        GEO_Knoten _gEOKnoten = null;
        if (topKnotenA != null) {
            _gEOKnoten = TopKnotenExtensions.getGEOKnoten(topKnotenA);
        }
        GEO_Knoten geoKnotenA = _gEOKnoten;
        GEO_Knoten _gEOKnoten_1 = null;
        if (topKnotenB != null) {
            _gEOKnoten_1 = TopKnotenExtensions.getGEOKnoten(topKnotenB);
        }
        GEO_Knoten geoKnotenB = _gEOKnoten_1;
        StringConcatenation _builder_1 = new StringConcatenation();
        _builder_1.append("TOP-Knoten A=");
        Identitaet_TypeClass _identitaet_1 = null;
        if (topKnotenA != null) {
            _identitaet_1 = topKnotenA.getIdentitaet();
        }
        String _wert_1 = null;
        if (_identitaet_1 != null) {
            _wert_1 = _identitaet_1.getWert();
        }
        _builder_1.append(_wert_1);
        _builder_1.append(" GEO-Knoten A=");
        Identitaet_TypeClass _identitaet_2 = null;
        if (geoKnotenA != null) {
            _identitaet_2 = geoKnotenA.getIdentitaet();
        }
        String _wert_2 = null;
        if (_identitaet_2 != null) {
            _wert_2 = _identitaet_2.getWert();
        }
        _builder_1.append(_wert_2);
        InputOutput.println((Object)_builder_1.toString());
        StringConcatenation _builder_2 = new StringConcatenation();
        _builder_2.append("TOP-Knoten B=");
        Identitaet_TypeClass _identitaet_3 = null;
        if (topKnotenB != null) {
            _identitaet_3 = topKnotenB.getIdentitaet();
        }
        String _wert_3 = null;
        if (_identitaet_3 != null) {
            _wert_3 = _identitaet_3.getWert();
        }
        _builder_2.append(_wert_3);
        _builder_2.append(" GEO-Knoten B=");
        Identitaet_TypeClass _identitaet_4 = null;
        if (geoKnotenB != null) {
            _identitaet_4 = geoKnotenB.getIdentitaet();
        }
        String _wert_4 = null;
        if (_identitaet_4 != null) {
            _wert_4 = _identitaet_4.getWert();
        }
        _builder_2.append(_wert_4);
        InputOutput.println((Object)_builder_2.toString());
        DirectedTopKante directedTopEdge = new DirectedTopKante(edge, true);
        List<DirectedElement<GEO_Kante>> directedGeoKanten = TopKanteExtensions.getGeoKanten(directedTopEdge);
        Consumer<DirectedElement> _function = it -> PlanProSchnittstelleDebugExtensions.println((DirectedElement<GEO_Kante>)it);
        directedGeoKanten.forEach(_function);
        boolean _doesCover = PlanProSchnittstelleDebugExtensions.doesCover(directedTopEdge, directedGeoKanten);
        if (_doesCover) {
            InputOutput.println((Object)"GEO-Kanten cover TOP-Kante.");
        } else {
            InputOutput.println((Object)"Error: GEO-Kanten do not cover TOP-Kante!");
            ++statistics.topCoverfailed;
        }
    }

    private static void println(DirectedElement<GEO_Kante> edge) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("Directed GEO-Kante ");
        GEO_Kante _element = null;
        if (edge != null) {
            _element = (GEO_Kante)edge.getElement();
        }
        Identitaet_TypeClass _identitaet = null;
        if (_element != null) {
            _identitaet = _element.getIdentitaet();
        }
        String _wert = null;
        if (_identitaet != null) {
            _wert = _identitaet.getWert();
        }
        _builder.append(_wert);
        _builder.append(" [");
        GEO_Knoten _tail = null;
        if (edge != null) {
            _tail = GeoKanteExtensions.getTail(edge);
        }
        Identitaet_TypeClass _identitaet_1 = null;
        if (_tail != null) {
            _identitaet_1 = _tail.getIdentitaet();
        }
        String _wert_1 = null;
        if (_identitaet_1 != null) {
            _wert_1 = _identitaet_1.getWert();
        }
        _builder.append(_wert_1);
        _builder.append(", ");
        GEO_Knoten _head = null;
        if (edge != null) {
            _head = GeoKanteExtensions.getHead(edge);
        }
        Identitaet_TypeClass _identitaet_2 = null;
        if (_head != null) {
            _identitaet_2 = _head.getIdentitaet();
        }
        String _wert_2 = null;
        if (_identitaet_2 != null) {
            _wert_2 = _identitaet_2.getWert();
        }
        _builder.append(_wert_2);
        _builder.append("]");
        InputOutput.println((Object)_builder.toString());
    }

    private static boolean doesCover(DirectedTopKante topEdge, List<DirectedElement<GEO_Kante>> geoEdges) {
        boolean _isEmpty = geoEdges.isEmpty();
        if (_isEmpty) {
            return false;
        }
        GEO_Knoten topFirst = TopKnotenExtensions.getGEOKnoten(topEdge.getTail());
        GEO_Knoten topLast = TopKnotenExtensions.getGEOKnoten(topEdge.getHead());
        GEO_Knoten geoFirst = GeoKanteExtensions.getTail((DirectedElement<GEO_Kante>)((DirectedElement)IterableExtensions.head(geoEdges)));
        DirectedElement _lastOrNull = (DirectedElement)IterableExtensions.lastOrNull(geoEdges);
        GEO_Knoten _head = null;
        if (_lastOrNull != null) {
            _head = GeoKanteExtensions.getHead((DirectedElement<GEO_Kante>)_lastOrNull);
        }
        GEO_Knoten geoLast = _head;
        return topFirst == geoFirst && topLast == geoLast;
    }

    private static class Statistics {
        private int total = 0;
        private int topCoverfailed = 0;

        private Statistics() {
        }
    }
}

