/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.ppmodel.extensions;

import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.set.model.planpro.BasisTypen.BasisAttribut_AttributeGroup;
import org.eclipse.set.model.planpro.Basisobjekte.Basis_Objekt;
import org.eclipse.set.model.planpro.Basisobjekte.Bearbeitungsvermerk;
import org.eclipse.set.model.planpro.Geodaten.GEO_Kante;
import org.eclipse.set.model.planpro.Geodaten.Strecke;
import org.eclipse.set.model.planpro.Geodaten.TOP_Kante;
import org.eclipse.set.ppmodel.extensions.StreckeExtensions;
import org.eclipse.set.ppmodel.extensions.TopKanteExtensions;
import org.eclipse.set.ppmodel.extensions.UrObjectExtensions;
import org.eclipse.set.ppmodel.extensions.utils.LstObjectAttribute;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasisObjektExtensions
extends UrObjectExtensions {
    private static final Logger logger = LoggerFactory.getLogger(BasisObjektExtensions.class);
    private static BigDecimal GEO_LENGTH_DEVIATION_TOLERANCE = BigDecimal.valueOf(0.001);
    private static BigDecimal GEO_LENGTH_DEVIATION_TOLERANCE_RELATIVE = BigDecimal.valueOf(1.0E-4);

    public static List<LstObjectAttribute> getObjectAttributes(Basis_Objekt object) {
        LinkedList result = Lists.newLinkedList();
        LstObjectAttribute _lstObjectAttribute = new LstObjectAttribute(object);
        result.add(_lstObjectAttribute);
        Procedures.Procedure1 _function = it -> {
            LstObjectAttribute _lstObjectAttribute_1 = new LstObjectAttribute(object, (BasisAttribut_AttributeGroup)it);
            result.add(_lstObjectAttribute_1);
        };
        IteratorExtensions.forEach((Iterator)Iterators.filter((Iterator)object.eAllContents(), BasisAttribut_AttributeGroup.class), (Procedures.Procedure1)_function);
        return result;
    }

    public static Iterable<Bearbeitungsvermerk> getBearbeitungsvermerk(Basis_Objekt object) {
        EList _iDBearbeitungsvermerk = object.getIDBearbeitungsvermerk();
        List _map = null;
        if (_iDBearbeitungsvermerk != null) {
            Functions.Function1 _function = it -> it.getValue();
            _map = ListExtensions.map((List)_iDBearbeitungsvermerk, (Functions.Function1)_function);
        }
        Iterable _filterNull = null;
        if (_map != null) {
            _filterNull = IterableExtensions.filterNull((Iterable)_map);
        }
        return _filterNull;
    }

    public static BigDecimal getGeoArtScalingFactor(Basis_Objekt geoArt) throws IllegalArgumentException {
        BigDecimal _multiply;
        BigDecimal tolerance;
        boolean _greaterThan;
        List<GEO_Kante> geoKantenOnGeoArt = BasisObjektExtensions.getGeoKanten(geoArt);
        BigDecimal geoLength = BigDecimal.ZERO;
        for (GEO_Kante geoKante : geoKantenOnGeoArt) {
            try {
                geoLength = geoLength.add(geoKante.getGEOKanteAllg().getGEOLaenge().getWert());
            }
            catch (Throwable _t) {
                if (_t instanceof NullPointerException) {
                    StringConcatenation _builder = new StringConcatenation();
                    _builder.append("Geo_Kante ");
                    String _wert = geoKante.getIdentitaet().getWert();
                    _builder.append(_wert);
                    _builder.append(" missing Geo_Laenge");
                    logger.error(_builder.toString());
                    continue;
                }
                throw Exceptions.sneakyThrow((Throwable)_t);
            }
        }
        BigDecimal geoArtLength = BasisObjektExtensions.geoArtLength(geoArt);
        BigDecimal diffrence = geoLength.subtract(geoArtLength).abs();
        boolean bl = _greaterThan = diffrence.compareTo(tolerance = GEO_LENGTH_DEVIATION_TOLERANCE.max(_multiply = geoArtLength.multiply(GEO_LENGTH_DEVIATION_TOLERANCE_RELATIVE))) > 0;
        if (_greaterThan) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("lengthGeoArt= ");
            _builder.append((Object)geoArtLength);
            logger.debug(_builder.toString());
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append("lengthGeoKanten= ");
            _builder_1.append((Object)geoLength);
            logger.debug(_builder_1.toString());
            StringConcatenation _builder_2 = new StringConcatenation();
            _builder_2.append("geoKantenOnGeoArt= ");
            int _size = geoKantenOnGeoArt.size();
            _builder_2.append((Object)_size);
            logger.debug(_builder_2.toString());
            StringConcatenation _builder_3 = new StringConcatenation();
            _builder_3.append("Difference of GEO_Kanten length and GeoArt length for GeoArt ");
            String _wert = geoArt.getIdentitaet().getWert();
            _builder_3.append(_wert);
            _builder_3.append(" greater than tolerance ");
            _builder_3.append((Object)tolerance);
            _builder_3.append(" (");
            _builder_3.append((Object)diffrence);
            _builder_3.append(")");
            logger.warn(_builder_3.toString());
        }
        if (geoLength.compareTo(BigDecimal.ZERO) <= 0 || geoArtLength.compareTo(BigDecimal.ZERO) <= 0) {
            return BigDecimal.ONE;
        }
        BigDecimal scale = geoLength.divide(geoArtLength, 5, RoundingMode.HALF_UP);
        BigDecimal _xifexpression = null;
        boolean _greaterThan_1 = scale.compareTo(BigDecimal.ZERO) > 0;
        _xifexpression = _greaterThan_1 ? scale : BigDecimal.ONE;
        return _xifexpression;
    }

    private static List<GEO_Kante> getGeoKanten(Basis_Objekt geoArt) {
        List<GEO_Kante> _switchResult = null;
        boolean _matched = false;
        if (geoArt instanceof TOP_Kante) {
            _matched = true;
            _switchResult = TopKanteExtensions.getGeoKanten((TOP_Kante)geoArt);
        }
        if (!_matched && geoArt instanceof Strecke) {
            _matched = true;
            _switchResult = StreckeExtensions.getGeoKanten((Strecke)geoArt);
        }
        if (!_matched) {
            throw new IllegalArgumentException("Unexpected value: " + String.valueOf(geoArt));
        }
        return _switchResult;
    }

    private static BigDecimal geoArtLength(Basis_Objekt geoArt) {
        BigDecimal _switchResult = null;
        boolean _matched = false;
        if (geoArt instanceof TOP_Kante) {
            _matched = true;
            _switchResult = ((TOP_Kante)geoArt).getTOPKanteAllg().getTOPLaenge().getWert();
        }
        if (!_matched && geoArt instanceof Strecke) {
            _matched = true;
            _switchResult = StreckeExtensions.getStreckeLength((Strecke)geoArt);
        }
        if (!_matched) {
            throw new IllegalArgumentException("Unexpected value: " + String.valueOf(geoArt));
        }
        return _switchResult;
    }
}

