/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.emfforms.controls;

import java.util.List;
import org.eclipse.emf.ecp.view.spi.custom.model.VCustomControl;
import org.eclipse.emf.ecp.view.spi.custom.swt.ECPAbstractCustomControlSWT;
import org.eclipse.emf.ecp.view.spi.model.VElement;
import org.eclipse.emf.ecp.view.spi.renderer.NoPropertyDescriptorFoundExeption;
import org.eclipse.emf.ecp.view.spi.renderer.NoRendererFoundException;
import org.eclipse.emfforms.spi.swt.core.layout.GridDescriptionFactory;
import org.eclipse.emfforms.spi.swt.core.layout.SWTGridCell;
import org.eclipse.emfforms.spi.swt.core.layout.SWTGridDescription;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.set.basis.emfforms.RendererContext;
import org.eclipse.set.core.services.Services;
import org.eclipse.set.core.services.viewmodel.ToolboxViewModelService;
import org.eclipse.set.emfforms.utils.RendererContextImpl;
import org.eclipse.set.utils.ButtonAction;
import org.eclipse.set.utils.emfforms.Annotations;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class ButtonControlBar
extends ECPAbstractCustomControlSWT {
    private ToolboxViewModelService toolboxViewModelService;

    public SWTGridDescription getGridDescription() {
        return GridDescriptionFactory.INSTANCE.createSimpleGrid(1, 1, null);
    }

    public Control renderControl(SWTGridCell cell, Composite parent) throws NoRendererFoundException, NoPropertyDescriptorFoundExeption {
        this.toolboxViewModelService = Services.getToolboxViewModelService();
        List buttonActionKeys = Annotations.getViewModelValues((VCustomControl)this.getCustomControl(), (String)"buttonActionKey");
        Composite composite = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().numColumns(buttonActionKeys.size() + 1).applyTo(composite);
        buttonActionKeys.forEach(key -> this.createButton((String)key, composite));
        return composite;
    }

    private void createButton(String key, Composite parent) {
        final ButtonAction buttonAction = (ButtonAction)this.toolboxViewModelService.get(key);
        if (buttonAction == null) {
            throw new IllegalArgumentException("Button action \"" + key + "\" not found.");
        }
        Button button = new Button(parent, 8);
        button.setText(buttonAction.getText());
        RendererContextImpl rendererContext = new RendererContextImpl();
        rendererContext.put(Button.class, button);
        rendererContext.put(VElement.class, this.getCustomControl());
        buttonAction.register((RendererContext)rendererContext);
        button.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                buttonAction.selected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                buttonAction.selected(e);
            }
        });
    }

    protected void disposeCustomControl() {
    }

    protected void handleContentValidation() {
    }
}

