/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.emfforms.basisattribute;

import jakarta.inject.Inject;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Optional;
import org.eclipse.emf.common.util.Enumerator;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecp.view.spi.context.ViewModelContext;
import org.eclipse.emf.ecp.view.spi.model.VControl;
import org.eclipse.emf.ecp.view.template.model.VTViewTemplateProvider;
import org.eclipse.emfforms.spi.common.report.ReportService;
import org.eclipse.emfforms.spi.core.services.databinding.EMFFormsDatabinding;
import org.eclipse.emfforms.spi.core.services.editsupport.EMFFormsEditSupport;
import org.eclipse.emfforms.spi.core.services.label.EMFFormsLabelProvider;
import org.eclipse.set.emfforms.basisattribute.AbstractBasisAttributeEnumeratorRenderer;
import org.eclipse.set.emfforms.basisattribute.BasisAttributeSetting;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasisAttributeEnumeratorRenderer
extends AbstractBasisAttributeEnumeratorRenderer<Enumerator> {
    private static final Logger LOGGER = LoggerFactory.getLogger(BasisAttributeEnumeratorRenderer.class);

    public static boolean isApplicable(EClassifier type) {
        return BasisAttributeSetting.isWertFeatureTypeAssignableTo(type, Enumerator.class);
    }

    @Inject
    public BasisAttributeEnumeratorRenderer(VControl vElement, ViewModelContext viewContext, ReportService reportService, EMFFormsDatabinding emfFormsDatabinding, EMFFormsLabelProvider emfFormsLabelProvider, VTViewTemplateProvider vtViewTemplateProvider, EMFFormsEditSupport emfFormsEditSupport) {
        super(Enumerator.class, vElement, viewContext, reportService, emfFormsDatabinding, emfFormsLabelProvider, vtViewTemplateProvider, emfFormsEditSupport);
        LOGGER.debug("Render {}", (Object)vElement);
    }

    @Override
    public BasisAttributeSetting<Enumerator> getBasisAttributeSetting() {
        return this.basisAttributeSetting;
    }

    @Override
    public Optional<Enumerator> valueOf(String representation) {
        EClassifier type = this.basisAttributeSetting.getWertFeature().getEType();
        try {
            Method getMethod = type.getInstanceClass().getMethod("get", String.class);
            return Optional.of((Enumerator)getMethod.invoke(null, representation));
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }

    @Override
    protected List<Object> getInputValues() {
        List<Object> inputValues = super.getInputValues();
        inputValues.add(0, "<empty value>");
        return inputValues;
    }
}

