/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.feature.projectdata.ppimport.control;

import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.nebula.jface.tablecomboviewer.TableComboViewer;
import org.eclipse.set.basis.IModelSession;
import org.eclipse.set.basis.constants.PlanProFileNature;
import org.eclipse.set.basis.files.ToolboxFile;
import org.eclipse.set.basis.files.ToolboxFileRole;
import org.eclipse.set.basis.guid.Guid;
import org.eclipse.set.core.services.modelloader.ModelLoader;
import org.eclipse.set.feature.projectdata.ppimport.ContainerComboSelection;
import org.eclipse.set.feature.projectdata.ppimport.ImportModelHandler;
import org.eclipse.set.feature.projectdata.ppimport.SubworkComboSelection;
import org.eclipse.set.feature.projectdata.utils.AbstractImportControl;
import org.eclipse.set.feature.projectdata.utils.ImportComboFileField;
import org.eclipse.set.feature.projectdata.utils.ServiceProvider;
import org.eclipse.set.model.planpro.PlanPro.PlanPro_Schnittstelle;
import org.eclipse.set.ppmodel.extensions.PlanProSchnittstelleExtensions;
import org.eclipse.set.utils.widgets.ComboValues;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ImportModelControl
extends AbstractImportControl {
    private PlanPro_Schnittstelle modelToImport;
    private final Map<String, byte[]> attachmentSource;
    private ImportComboFileField comboField;
    private final ImportTarget importType;
    private ImportModelHandler importHandler;
    private final Runnable handleControlChange;

    public ImportModelControl(ServiceProvider serviceProvider, IModelSession modelSession, ImportTarget importType, Runnable handleControlChange) {
        super(serviceProvider, modelSession);
        this.importType = importType;
        this.setImported(false);
        this.attachmentSource = new HashMap<String, byte[]>();
        this.handleControlChange = handleControlChange;
    }

    @Override
    public boolean isValid() {
        return this.comboField.isValid();
    }

    public ImportTarget getImportTarget() {
        return this.importType;
    }

    @Override
    public void resetControl() {
        this.modelToImport = null;
        this.attachmentSource.clear();
        this.comboField.getText().setText("");
        this.comboField.setDefaultCombo();
        this.setImported(false);
    }

    @Override
    public boolean isEnabled() {
        return this.comboField.isEnabled();
    }

    @Override
    public void doImport(Shell shell) {
        if (this.modelToImport == null || this.importHandler == null || !this.isEnabled()) {
            return;
        }
        this.setImported(this.importHandler.doImport(this.modelSession, this.attachmentSource, shell));
    }

    @Override
    public void createControl(Composite parent, Shell shell, ToolboxFileRole role) {
        this.comboField = this.createImportFileFieldCombo(parent, shell, role);
    }

    private ImportComboFileField createImportFileFieldCombo(Composite parent, Shell shell, ToolboxFileRole role) {
        ImportComboFileField fileFieldCombo = new ImportComboFileField(parent, this.serviceProvider.dialogService.getModelFileFilters(), this.serviceProvider.dialogService, this.serviceProvider.messages);
        fileFieldCombo.getComposite().setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        fileFieldCombo.getButton().setText(this.serviceProvider.messages.PlanProImportPart_fileFieldButtonText);
        fileFieldCombo.setPathValidation(path -> this.validatePath((Path)path, t -> {
            this.modelToImport = t.schnittStelle();
            this.importHandler = new ImportModelHandler(this.comboField, this.modelToImport, this.importType, this.serviceProvider);
        }, shell, role));
        fileFieldCombo.setDefaultCombo();
        fileFieldCombo.setEnabled(false);
        fileFieldCombo.getText().addModifyListener(this.selectedFileHandle());
        fileFieldCombo.getSubworkCombo().addSelectionChangedListener(this.selectionSubworkHanlder());
        fileFieldCombo.getContainerCombo().addSelectionListener(this.selectionContainerHandle());
        return fileFieldCombo;
    }

    public ImportComboFileField getComboField() {
        return this.comboField;
    }

    @Override
    protected Boolean validatePath(ToolboxFile toolboxFile, Consumer<ModelLoader.ModelContents> storeModel, Shell shell) {
        Boolean isValid = super.validatePath(toolboxFile, storeModel, shell);
        if (toolboxFile.getFormat().isZippedPlanPro()) {
            try {
                toolboxFile.getAllMedia().stream().forEach(guid -> {
                    try {
                        this.attachmentSource.put((String)guid, toolboxFile.getMedia(Guid.create((String)guid)));
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                });
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return isValid;
    }

    @Override
    protected ModifyListener selectedFileHandle() {
        return e -> {
            Text text;
            Object object = e.getSource();
            if (object instanceof Text && (text = (Text)object).getText().isBlank() || this.modelToImport == null) {
                return;
            }
            if (PlanProSchnittstelleExtensions.isPlanning((PlanPro_Schnittstelle)this.modelToImport)) {
                this.setComboValues(PlanProFileNature.PLANNING);
            } else {
                this.setComboValues(PlanProFileNature.INFORMATION_STATE);
            }
            this.handleControlChange.run();
        };
    }

    private ISelectionChangedListener selectionSubworkHanlder() {
        return event -> {
            if (!this.comboField.getContainerCombo().isDisposed()) {
                this.comboField.getContainerCombo().setEnabled(!this.comboField.isNotSelected((TableComboViewer)this.comboField.getSubworkCombo()) && this.comboField.getContainerCombo().getItems().length > 1);
            } else {
                this.handleControlChange.run();
            }
        };
    }

    private SelectionListener selectionContainerHandle() {
        return new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                this.widgetDefaultSelected(e);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                ImportModelControl.this.handleControlChange.run();
            }
        };
    }

    private void setComboValues(PlanProFileNature fileNature) {
        ComboValues<SubworkComboSelection> subworkValues = SubworkComboSelection.getComboValues(this.modelToImport, fileNature, this.serviceProvider.messages);
        this.comboField.setSubworkComboValues(subworkValues);
        ComboValues<ContainerComboSelection> containerValues = ContainerComboSelection.getComboValues(fileNature, this.serviceProvider.messages);
        this.comboField.setContainerComboValues(containerValues);
    }

    public static enum ImportTarget {
        ALL,
        INITIAL,
        FINAL;

    }
}

