/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.application.parts;

import jakarta.inject.Inject;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import org.apache.tika.Tika;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.services.nls.Translation;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.set.application.Messages;
import org.eclipse.set.basis.extensions.PathExtensions;
import org.eclipse.set.browser.DownloadListener;
import org.eclipse.set.core.services.configurationservice.UserConfigurationService;
import org.eclipse.set.core.services.pdf.PdfRendererService;
import org.eclipse.set.core.services.pdf.PdfViewer;
import org.eclipse.set.core.services.pdf.PdfViewerPart;
import org.eclipse.set.model.planpro.Basisobjekte.ENUMDateityp;
import org.eclipse.set.utils.BasePart;
import org.eclipse.set.utils.FileWebBrowser;
import org.eclipse.set.utils.SelectableAction;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;

public class AttachmentViewerPart
extends BasePart
implements PdfViewerPart,
PdfViewer.SaveListener,
DownloadListener {
    @Optional
    @Inject
    private PdfRendererService rendererService;
    private PdfViewer viewer;
    @Inject
    @Translation
    Messages messages;
    @Inject
    UserConfigurationService userConfigService;

    @Inject
    public AttachmentViewerPart() {
    }

    public PdfViewer getViewer() {
        return this.viewer;
    }

    protected void createView(Composite parent) {
        String filename = (String)this.getToolboxPart().getTransientData().get("org.eclipse.set.application.commandparameter.file");
        final Path path = Paths.get(filename, new String[0]);
        this.getBanderole().setExportAction(new SelectableAction(){

            public String getText() {
                return AttachmentViewerPart.this.messages.AttachmentViewerPart_ExportButton;
            }

            public void selected(SelectionEvent e) {
                AttachmentViewerPart.this.export(path);
            }
        });
        try {
            String extension = PathExtensions.getExtension((Path)path);
            if (this.rendererService != null && extension.equals(ENUMDateityp.ENUM_DATEITYP_PDF.getLiteral())) {
                this.viewer = this.rendererService.createViewer(parent);
                this.viewer.show(path);
                this.viewer.setSaveListener((PdfViewer.SaveListener)this);
            } else {
                this.viewAttachmentFile(parent, path);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Error by viewing Attachment File ", e);
        }
    }

    protected void viewAttachmentFile(Composite parent, Path path) throws IOException {
        String mime = new Tika().detect(path);
        FileWebBrowser fileWebBrowser = new FileWebBrowser(parent);
        fileWebBrowser.getBrowser().setDownloadListener((DownloadListener)this);
        GridDataFactory.swtDefaults().align(4, 4).grab(true, true).span(2, 1).applyTo(fileWebBrowser.getControl());
        String serverPath = path.getFileName().toString();
        String attachmentUrl = "https://toolbox/attachmentSource";
        String htmlSite = AttachmentViewerPart.createAttachmentViewerHTML(serverPath, "https://toolbox/attachmentSource", mime);
        fileWebBrowser.serveFile("attachmentSource", mime, path);
        fileWebBrowser.serveUri(serverPath, respone -> {
            respone.setMimeType("text/html");
            respone.setStatus(200);
            respone.setResponseData(htmlSite);
        });
        fileWebBrowser.setUrl("https://toolbox/" + serverPath);
    }

    protected static String createAttachmentViewerHTML(String sourceName, String attachmentSource, String mime) {
        String htmlTag = "";
        if (mime.startsWith("image")) {
            htmlTag = String.format("<image src=\"%s\">\n", attachmentSource);
        } else if (mime.startsWith("video")) {
            htmlTag = String.format("\t<video controls>\n\t\t<source src=\"%s\" type=\"%s\">\n\t</video>\n", attachmentSource, mime);
        }
        return String.format("\t<!DOCTYPE html>\n\t<html lang=\"\">\n\t\t\t<head>\n\t\t\t\t\t<meta charset=\"utf-8\" />\n\t\t\t\t\t<meta name=\"viewport\" content=\"width=device-width,initial-scale=1.0\" />\n\t\t\t\t\t<title>%s</title>\n\t\t\t</head>\n\t\t\t<body>\n\t\t\t\t\t<div>\n\t\t\t\t\t\t\t%s\n\t\t\t\t\t</div>\n\t\t\t</body>\n\t</html>\n", sourceName, htmlTag);
    }

    public java.util.Optional<Path> saveFile(String filename) {
        Shell shell = this.getToolboxShell();
        Path location = this.getModelSession().getToolboxFile().getPath();
        Path parent = location.getParent();
        String defaultPath = parent == null ? "" : parent.toString();
        String defaultFileName = String.format(filename, PathExtensions.getBaseFileName((Path)location));
        return this.getDialogService().saveFileDialog(shell, this.getDialogService().getDokumentFileFilters(), Paths.get(defaultPath, defaultFileName));
    }

    public void saveCompleted(Path path) {
        this.getDialogService().reportSavedFile(this.getToolboxShell(), path);
    }

    protected void export(Path source) {
        java.util.Optional optionalOutputDir = this.getDialogService().selectDirectory(this.getToolboxShell(), this.userConfigService.getLastExportPath().toString());
        optionalOutputDir.ifPresent(outputDir -> {
            boolean overwrite;
            Path dest = Paths.get(outputDir, source.getFileName().toString());
            if (dest.toFile().exists() && !(overwrite = this.getDialogService().confirmOverwrite(this.getToolboxShell(), dest))) {
                return;
            }
            try {
                Files.copy(source, dest, StandardCopyOption.REPLACE_EXISTING);
                this.getDialogService().openDirectoryAfterExport(this.getToolboxShell(), Paths.get(outputDir, new String[0]));
            }
            catch (IOException e) {
                this.getDialogService().error(this.getToolboxShell(), this.messages.AttachmentViewerPart_ExportErrorTitle, String.format(this.messages.AttachmentViewerPart_ExportErrorText, dest.toString()), (Exception)e);
            }
        });
    }

    public java.util.Optional<Path> beforeDownload(String suggestedName, String url) {
        return this.saveFile(suggestedName);
    }

    public void downloadFinished(boolean success, Path path) {
        this.saveCompleted(path);
    }
}

