/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.application.graph;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.set.basis.IModelSession;
import org.eclipse.set.basis.constants.ContainerType;
import org.eclipse.set.basis.files.ToolboxFileRole;
import org.eclipse.set.basis.graph.TopPath;
import org.eclipse.set.basis.graph.TopPoint;
import org.eclipse.set.core.services.Services;
import org.eclipse.set.core.services.graph.TopologicalGraphService;
import org.eclipse.set.core.services.session.SessionService;
import org.eclipse.set.model.planpro.Geodaten.TOP_Kante;
import org.eclipse.set.model.planpro.PlanPro.PlanPro_Schnittstelle;
import org.eclipse.set.ppmodel.extensions.BasisAttributExtensions;
import org.eclipse.set.ppmodel.extensions.MultiContainer_AttributeGroupExtensions;
import org.eclipse.set.ppmodel.extensions.PlanProSchnittstelleExtensions;
import org.eclipse.set.ppmodel.extensions.container.MultiContainer_AttributeGroup;
import org.eclipse.set.utils.graph.AsDirectedTopGraph;
import org.eclipse.set.utils.graph.AsSplitTopGraph;
import org.jgrapht.Graph;
import org.jgrapht.GraphPath;
import org.jgrapht.alg.shortestpath.DijkstraShortestPath;
import org.jgrapht.graph.WeightedPseudograph;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;
import org.osgi.service.event.EventHandler;

@Component(property={"event.topics=modelsession/change/model", "event.topics=modelsession/loaded/compare", "event.topics=modelsession/close"}, service={EventHandler.class, TopologicalGraphService.class})
public class TopologicalGraphServiceImpl
implements TopologicalGraphService,
EventHandler {
    private final Map<PlanPro_Schnittstelle, WeightedPseudograph<AsSplitTopGraph.Node, AsSplitTopGraph.Edge>> topGraphBaseMap = new HashMap<PlanPro_Schnittstelle, WeightedPseudograph<AsSplitTopGraph.Node, AsSplitTopGraph.Edge>>();
    @Reference
    EventAdmin eventAdmin;
    @Reference
    SessionService sessionService;

    public TopologicalGraphServiceImpl() {
        Services.setTopGraphService((TopologicalGraphService)this);
    }

    public void handleEvent(Event event) {
        if (event.getTopic().equals("modelsession/close")) {
            ToolboxFileRole role = (ToolboxFileRole)event.getProperty("org.eclipse.e4.data");
            if (role == ToolboxFileRole.SESSION) {
                this.topGraphBaseMap.clear();
            } else {
                this.topGraphBaseMap.remove(this.sessionService.getLoadedSession(role).getPlanProSchnittstelle());
            }
            return;
        }
        IModelSession modelsession = (IModelSession)event.getProperty("org.eclipse.e4.data");
        PlanPro_Schnittstelle planProSchnittstelle = modelsession.getPlanProSchnittstelle();
        WeightedPseudograph<AsSplitTopGraph.Node, AsSplitTopGraph.Edge> topGraphBase = this.getTopGraphBase(planProSchnittstelle);
        TopologicalGraphServiceImpl.addContainerToGraph(topGraphBase, PlanProSchnittstelleExtensions.getContainer((PlanPro_Schnittstelle)planProSchnittstelle, (ContainerType)ContainerType.INITIAL));
        TopologicalGraphServiceImpl.addContainerToGraph(topGraphBase, PlanProSchnittstelleExtensions.getContainer((PlanPro_Schnittstelle)planProSchnittstelle, (ContainerType)ContainerType.FINAL));
        TopologicalGraphServiceImpl.addContainerToGraph(topGraphBase, PlanProSchnittstelleExtensions.getContainer((PlanPro_Schnittstelle)planProSchnittstelle, (ContainerType)ContainerType.SINGLE));
        HashMap<String, PlanPro_Schnittstelle> properties = new HashMap<String, PlanPro_Schnittstelle>();
        properties.put("org.eclipse.e4.data", planProSchnittstelle);
        this.eventAdmin.sendEvent(new Event("modelsession/change/topmodel", properties));
    }

    private static void addContainerToGraph(WeightedPseudograph<AsSplitTopGraph.Node, AsSplitTopGraph.Edge> topGraphBase, MultiContainer_AttributeGroup container) {
        if (container == null) {
            return;
        }
        container.getTOPKante().forEach(edge -> TopologicalGraphServiceImpl.addEdge(topGraphBase, edge));
    }

    private WeightedPseudograph<AsSplitTopGraph.Node, AsSplitTopGraph.Edge> getTopGraphBase(PlanPro_Schnittstelle schnittstelle) {
        return this.topGraphBaseMap.computeIfAbsent(schnittstelle, k -> new WeightedPseudograph(AsSplitTopGraph.Edge.class));
    }

    private static void addEdge(WeightedPseudograph<AsSplitTopGraph.Node, AsSplitTopGraph.Edge> topGraphBase, TOP_Kante edge) {
        AsSplitTopGraph.Node a = new AsSplitTopGraph.Node(edge.getIDTOPKnotenA().getValue());
        AsSplitTopGraph.Node b = new AsSplitTopGraph.Node(edge.getIDTOPKnotenB().getValue());
        topGraphBase.addVertex((Object)a);
        topGraphBase.addVertex((Object)b);
        AsSplitTopGraph.Edge graphEdge = new AsSplitTopGraph.Edge(edge);
        topGraphBase.addEdge((Object)a, (Object)b, (Object)graphEdge);
        topGraphBase.setEdgeWeight((Object)graphEdge, edge.getTOPKanteAllg().getTOPLaenge().getWert().doubleValue());
    }

    public List<TopPath> findAllPathsBetween(TopPoint from, TopPoint to, int limit) {
        MultiContainer_AttributeGroup container = BasisAttributExtensions.getContainer((EObject)from.edge());
        PlanPro_Schnittstelle planProSchnittstelle = MultiContainer_AttributeGroupExtensions.getPlanProSchnittstelle((MultiContainer_AttributeGroup)container);
        return AsDirectedTopGraph.getAllPaths((AsSplitTopGraph)new AsSplitTopGraph(this.getTopGraphBase(planProSchnittstelle)), (TopPoint)from, (TopPoint)to, (int)limit);
    }

    public TopPath findPathBetween(TopPoint from, TopPoint to, int limit, Predicate<TopPath> condition) {
        MultiContainer_AttributeGroup container = BasisAttributExtensions.getContainer((EObject)from.edge());
        PlanPro_Schnittstelle planProSchnittstelle = MultiContainer_AttributeGroupExtensions.getPlanProSchnittstelle((MultiContainer_AttributeGroup)container);
        return AsDirectedTopGraph.getPath((AsSplitTopGraph)new AsSplitTopGraph(this.getTopGraphBase(planProSchnittstelle)), (TopPoint)from, (TopPoint)to, (int)limit, condition);
    }

    public Optional<BigDecimal> findShortestDistanceInDirection(TopPoint from, TopPoint to, boolean searchInTopDirection) {
        MultiContainer_AttributeGroup container = BasisAttributExtensions.getContainer((EObject)from.edge());
        PlanPro_Schnittstelle planProSchnittstelle = MultiContainer_AttributeGroupExtensions.getPlanProSchnittstelle((MultiContainer_AttributeGroup)container);
        AsSplitTopGraph graphView = new AsSplitTopGraph(this.getTopGraphBase(planProSchnittstelle));
        AsSplitTopGraph.Node fromNode = graphView.splitGraphAt(from, Boolean.valueOf(searchInTopDirection));
        AsSplitTopGraph.Node toNode = graphView.splitGraphAt(to);
        return Optional.ofNullable(TopologicalGraphServiceImpl.findPathBetween(graphView, fromNode, toNode)).map(p -> TopologicalGraphServiceImpl.getPathWeight((GraphPath<AsSplitTopGraph.Node, AsSplitTopGraph.Edge>)p));
    }

    public Optional<TopPath> findShortestPath(TopPoint from, TopPoint to) {
        MultiContainer_AttributeGroup container = BasisAttributExtensions.getContainer((EObject)from.edge());
        PlanPro_Schnittstelle planProSchnittstelle = MultiContainer_AttributeGroupExtensions.getPlanProSchnittstelle((MultiContainer_AttributeGroup)container);
        AsSplitTopGraph graphView = new AsSplitTopGraph(this.getTopGraphBase(planProSchnittstelle));
        AsSplitTopGraph.Node fromNode = graphView.splitGraphAt(from);
        AsSplitTopGraph.Node toNode = graphView.splitGraphAt(to);
        return Optional.ofNullable(TopologicalGraphServiceImpl.findPathBetween(graphView, fromNode, toNode)).map(p -> new TopPath(p.getEdgeList().stream().map(AsSplitTopGraph.Edge::edge).distinct().toList(), TopologicalGraphServiceImpl.getPathWeight((GraphPath<AsSplitTopGraph.Node, AsSplitTopGraph.Edge>)p), from));
    }

    private static GraphPath<AsSplitTopGraph.Node, AsSplitTopGraph.Edge> findPathBetween(AsSplitTopGraph graphView, AsSplitTopGraph.Node fromNode, AsSplitTopGraph.Node toNode) {
        try {
            return DijkstraShortestPath.findPathBetween((Graph)graphView, (Object)fromNode, (Object)toNode);
        }
        catch (IllegalArgumentException ex) {
            if (ex.getMessage().equals("Negative edge weight not allowed")) {
                throw new IllegalArgumentException("Invalid spot location", ex);
            }
            throw ex;
        }
    }

    private static BigDecimal getPathWeight(GraphPath<AsSplitTopGraph.Node, AsSplitTopGraph.Edge> path) {
        return path.getEdgeList().stream().map(AsSplitTopGraph.Edge::getWeight).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
    }

    public Optional<BigDecimal> findShortestDistance(TopPoint from, TopPoint to) {
        return this.findShortestPath(from, to).map(TopPath::length);
    }

    public Optional<TopPoint> findClosestPoint(TopPoint from, List<TopPoint> points, boolean searchInTopDirection) {
        MultiContainer_AttributeGroup container = BasisAttributExtensions.getContainer((EObject)from.edge());
        PlanPro_Schnittstelle planProSchnittstelle = MultiContainer_AttributeGroupExtensions.getPlanProSchnittstelle((MultiContainer_AttributeGroup)container);
        AsSplitTopGraph graphView = new AsSplitTopGraph(this.getTopGraphBase(planProSchnittstelle));
        AsSplitTopGraph.Node fromNode = graphView.splitGraphAt(from, Boolean.valueOf(searchInTopDirection));
        BigDecimal minWeight = BigDecimal.valueOf(1000000L);
        Optional<TopPoint> minPoint = Optional.empty();
        for (TopPoint point : points) {
            AsSplitTopGraph.Node toNode = null;
            try {
                toNode = graphView.splitGraphAt(point);
            }
            catch (IllegalArgumentException e) {
                continue;
            }
            GraphPath<AsSplitTopGraph.Node, AsSplitTopGraph.Edge> path = TopologicalGraphServiceImpl.findPathBetween(graphView, fromNode, toNode);
            if (path == null) continue;
            BigDecimal weight = TopologicalGraphServiceImpl.getPathWeight(path);
            if (!minPoint.isEmpty() && weight.compareTo(minWeight) >= 0) continue;
            minWeight = weight;
            minPoint = Optional.of(point);
        }
        return minPoint;
    }
}

