/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.application.cacheservice;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.set.application.cacheservice.CacheImpl;
import org.eclipse.set.basis.IModelSession;
import org.eclipse.set.basis.cache.Cache;
import org.eclipse.set.basis.files.ToolboxFileRole;
import org.eclipse.set.core.services.Services;
import org.eclipse.set.core.services.cache.CacheService;
import org.eclipse.set.core.services.cache.NoCacheService;
import org.eclipse.set.core.services.session.SessionService;
import org.eclipse.set.model.planpro.PlanPro.PlanPro_Schnittstelle;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

@Component(property={"event.topics=modelsession/change/model", "event.topics=modelsession/close"}, service={EventHandler.class, CacheService.class})
public class CacheServiceImpl
implements CacheService,
EventHandler {
    @Reference
    SessionService sessionService;
    private final Map<ToolboxFileRole, Map<String, Cache>> caches = new ConcurrentHashMap<ToolboxFileRole, Map<String, Cache>>();

    public CacheServiceImpl() {
        Services.setCacheService((CacheService)this);
        Services.setNoCacheService((NoCacheService)new NoCacheService());
    }

    public Cache getCache(PlanPro_Schnittstelle schnittstelle, String cacheId) {
        return this.getCache(this.getSessionRole(schnittstelle), cacheId);
    }

    public Cache getCache(PlanPro_Schnittstelle schnittstelle, String cacheId, String containerCacheId) throws IllegalArgumentException {
        return this.getCache(this.getSessionRole(schnittstelle), cacheId, containerCacheId);
    }

    private void invalidate(ToolboxFileRole role) {
        if (role == ToolboxFileRole.SESSION) {
            this.caches.values().stream().flatMap(ele -> ele.values().stream()).forEach(Cache::invalidate);
        } else {
            this.caches.get(role).values().forEach(Cache::invalidate);
        }
    }

    public void handleEvent(Event event) {
        if (event.getTopic().equals("modelsession/close")) {
            ToolboxFileRole role = (ToolboxFileRole)event.getProperty("org.eclipse.e4.data");
            this.invalidate(role);
            return;
        }
        IModelSession modelSession = (IModelSession)event.getProperty("org.eclipse.e4.data");
        this.invalidate(modelSession.getToolboxFile().getRole());
    }

    public Boolean existCache(PlanPro_Schnittstelle schnittstelle, String cacheID) {
        return this.existCache(this.getSessionRole(schnittstelle), cacheID);
    }

    private ToolboxFileRole getSessionRole(PlanPro_Schnittstelle schnittStelle) {
        Map loadedSessions = this.sessionService.getLoadedSessions();
        Map.Entry targetSession = loadedSessions.entrySet().stream().filter(entry -> ((IModelSession)entry.getValue()).getPlanProSchnittstelle() == schnittStelle).findFirst().orElse(null);
        if (targetSession != null) {
            return (ToolboxFileRole)targetSession.getKey();
        }
        return ToolboxFileRole.SESSION;
    }

    public Cache getCache(ToolboxFileRole role, String cacheId) throws IllegalArgumentException {
        Map sessionCaches = this.caches.computeIfAbsent(role, k -> new ConcurrentHashMap());
        return sessionCaches.computeIfAbsent(cacheId, CacheImpl::new);
    }

    public Cache getCache(ToolboxFileRole role, String cacheId, String containerCacheId) throws IllegalArgumentException {
        String cacheKey = cacheId + "/" + containerCacheId;
        return this.getCache(role, cacheKey);
    }

    public Boolean existCache(ToolboxFileRole role, String cacheID) {
        return this.caches.get(role).keySet().contains(cacheID);
    }
}

