/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.utils.export.xsl.siteplan;

import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;

public class SiteplanXSLExtension {
    public static final double DEFAULT_MARGIN_TOP_BOTTOM = 10.0;
    public static final double DEFAULT_MARGIN_LEFT = 20.0;
    public static final double DEFAULT_MARGIN_RIGHT = 10.0;
    private static double FIRST_FOLD_PAGE_WIDTH_GREATER_THAN_A3 = 210.0;
    private static double LAST_FOLD_WIDTH = 190.0;
    private static double MAX_BETWEEN_FOLD_WIDTH = 190.0;
    private static double MIN_BETWEEN_FOLD_WIDTH = 80.0;

    public static List<Double> calculateCustomFoldingTopBottom(double pageWidth) {
        List<Double> dinFolding = SiteplanXSLExtension.getDINFolding(pageWidth);
        if (dinFolding != null) {
            return dinFolding;
        }
        if (pageWidth <= PageDIN.A3.getPageWidth()) {
            return SiteplanXSLExtension.calculateCustomFoldingSmallThanA3(pageWidth);
        }
        double firstFold = FIRST_FOLD_PAGE_WIDTH_GREATER_THAN_A3;
        double lastFold = LAST_FOLD_WIDTH;
        double remainingWidth = pageWidth - firstFold - lastFold;
        int foldCount = 1;
        while (foldCount < 99) {
            int totalFoldCount = foldCount + 2;
            if (totalFoldCount % 2 != 0) {
                LinkedList<Double> result = new LinkedList<Double>();
                double remaining = remainingWidth;
                int i = 0;
                while (i < foldCount) {
                    int remainingFoldCount = foldCount - i;
                    if (remaining >= MAX_BETWEEN_FOLD_WIDTH && remaining - MAX_BETWEEN_FOLD_WIDTH > MIN_BETWEEN_FOLD_WIDTH) {
                        result.add(MAX_BETWEEN_FOLD_WIDTH);
                        remaining -= MAX_BETWEEN_FOLD_WIDTH;
                    } else {
                        BigDecimal currentFoldWidth = BigDecimal.valueOf(Math.min(MAX_BETWEEN_FOLD_WIDTH, remaining / (double)remainingFoldCount));
                        currentFoldWidth = currentFoldWidth.setScale(2, RoundingMode.HALF_UP);
                        result.add(currentFoldWidth.doubleValue());
                        remaining -= currentFoldWidth.doubleValue();
                    }
                    ++i;
                }
                if (Math.abs(remaining) < 0.5) {
                    result.addFirst(firstFold);
                    result.addLast(lastFold);
                    return result;
                }
            }
            ++foldCount;
        }
        return Collections.emptyList();
    }

    private static List<Double> getDINFolding(double width) {
        Optional<PageDIN> relevantDIN = Arrays.stream(PageDIN.values()).filter(din -> din.getPageWidth() == width).findFirst();
        if (relevantDIN.isEmpty()) {
            return null;
        }
        return relevantDIN.get().getFoldingMarkTopBottomWidth();
    }

    private static List<Double> calculateCustomFoldingSmallThanA3(double totalWidth) {
        double lastFold = 190.0;
        double remainingWidth = totalWidth - 190.0;
        BigDecimal firstFold = BigDecimal.valueOf((remainingWidth + 20.0) / 2.0);
        firstFold = firstFold.setScale(2, RoundingMode.HALF_UP);
        return List.of(Double.valueOf(firstFold.doubleValue()), Double.valueOf(remainingWidth - firstFold.doubleValue()), Double.valueOf(190.0));
    }

    public static final class FoldingMark
    extends Record {
        private final RegionPosition position;
        private final List<Double> distances;
        private final double extent;
        private final double markWidth;
        public static final double DEFAULT_EXTENT_TOP_BOTTOM_RIGHT = 10.0;
        public static final double DEFAULT_EXTENT_LEFT = 20.0;
        public static final double DEFAULT_MARK_WIDTH = 5.0;

        public FoldingMark(RegionPosition position, List<Double> distances, double extent, double markWidth) {
            this.position = position;
            this.distances = distances;
            this.extent = extent;
            this.markWidth = markWidth;
        }

        public FoldingMark(RegionPosition position, List<Double> distances) {
            this(position, distances, switch (position) {
                case RegionPosition.START -> 20.0;
                default -> 10.0;
            }, 5.0);
        }

        public FoldingMark(RegionPosition position, double ... distance) {
            LinkedList<Double> linkedList = new LinkedList<Double>(Arrays.stream(distance).boxed().toList());
            this(position, linkedList, switch (position) {
                case RegionPosition.START -> 20.0;
                default -> 10.0;
            }, 5.0);
        }

        public RegionPosition position() {
            return this.position;
        }

        public List<Double> distances() {
            return this.distances;
        }

        public double extent() {
            return this.extent;
        }

        public double markWidth() {
            return this.markWidth;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{FoldingMark.class, "position;distances;extent;markWidth", "position", "distances", "extent", "markWidth"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{FoldingMark.class, "position;distances;extent;markWidth", "position", "distances", "extent", "markWidth"}, this);
        }

        @Override
        public final boolean equals(Object object) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{FoldingMark.class, "position;distances;extent;markWidth", "position", "distances", "extent", "markWidth"}, this, object);
        }
    }

    public static enum PageDIN {
        A3("A3", 420.0, 297.0),
        A2("A2", 594.0, 420.0),
        A1("A1", 841.0, 594.0),
        A0("A0", 1189.0, 841.0);

        private final double pageWidth;
        private final double pageHeight;
        private final String pageDIN;

        private PageDIN(String din, double width, double height) {
            this.pageHeight = height;
            this.pageWidth = width;
            this.pageDIN = din;
        }

        public double getPageWidth() {
            return this.pageWidth;
        }

        public double getPageHeight() {
            return this.pageHeight;
        }

        public List<Double> getFoldingMarkTopBottomWidth() {
            return switch (this.pageDIN) {
                case "A3" -> List.of(Double.valueOf(125.0), Double.valueOf(105.0), Double.valueOf(190.0));
                case "A2" -> List.of(Double.valueOf(210.0), Double.valueOf(192.0), Double.valueOf(192.0));
                case "A1" -> List.of(Double.valueOf(210.0), Double.valueOf(190.0), Double.valueOf(125.5), Double.valueOf(125.5), Double.valueOf(190.0));
                case "A0" -> List.of(Double.valueOf(210.0), Double.valueOf(190.0), Double.valueOf(190.0), Double.valueOf(190.0), Double.valueOf(109.5), Double.valueOf(109.5), Double.valueOf(190.0));
                default -> Collections.emptyList();
            };
        }

        public List<Double> getFoldingMarkSide() {
            return switch (this.pageDIN) {
                case "A2" -> List.of(Double.valueOf(113.0), Double.valueOf(287.0));
                case "A1" -> List.of(Double.valueOf(287.0), Double.valueOf(287.0));
                case "A0" -> List.of(Double.valueOf(237.0), Double.valueOf(297.0), Double.valueOf(287.0));
                default -> Collections.emptyList();
            };
        }

        public String toString() {
            return this.pageDIN;
        }
    }

    public record RegionBody(double width, double height) {
    }

    public static enum RegionPosition {
        BEFORE("region-before"),
        AFTER("region-after"),
        START("region-start"),
        END("region-end"),
        BODY("region-body");

        private final String regionName;

        private RegionPosition(String name) {
            this.regionName = name;
        }

        public String getRegionTag() {
            return "fo:" + this.regionName;
        }

        public String getRegionName() {
            return this.regionName;
        }
    }

    public record SignificantInformation(double width, double height) {
        private static final double DEFAULT_HEIGHT = 10.0;

        public SignificantInformation(double width) {
            this(width, 10.0);
        }
    }

    public record TitleBoxRegion(RegionPosition position, double extent, double freefeldSize) {
        public static final double TITLEBOX_WIDTH = 180.0;
        public static final double TITLEBOX_HEIGHT = 75.0;
    }
}

