/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.feature.plazmodel.table;

import java.util.List;
import org.eclipse.emf.common.util.Enumerator;
import org.eclipse.set.core.services.enumtranslation.EnumTranslationService;
import org.eclipse.set.feature.plazmodel.table.PlazReportColumns;
import org.eclipse.set.model.plazmodel.PlazReport;
import org.eclipse.set.model.tablemodel.ColumnDescriptor;
import org.eclipse.set.model.tablemodel.TableRow;
import org.eclipse.set.model.validationreport.ObjectScope;
import org.eclipse.set.model.validationreport.ObjectState;
import org.eclipse.set.model.validationreport.ValidationProblem;
import org.eclipse.set.utils.table.tree.AbstractValidationProblemTransformator;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Functions;

public class PlazModelTableTransformator
extends AbstractValidationProblemTransformator<PlazReport> {
    private PlazReportColumns columns;
    protected final EnumTranslationService enumTranslationService;
    protected final List<ColumnDescriptor> excludeColumns;

    public PlazModelTableTransformator(PlazReportColumns columns, EnumTranslationService enumTranslationService) {
        this.columns = columns;
        this.enumTranslationService = enumTranslationService;
        this.excludeColumns = CollectionLiterals.newArrayList((Object[])new ColumnDescriptor[]{columns.RowIndex, columns.Message, columns.LineNumber});
    }

    public void fillProblem(TableRow instance, ValidationProblem problem) {
        boolean _tripleNotEquals_1;
        boolean _tripleNotEquals;
        int _id = problem.getId();
        boolean bl = _tripleNotEquals = _id != 0;
        if (_tripleNotEquals) {
            Functions.Function1 _function = it -> Integer.valueOf(problem.getId()).toString();
            this.fill(instance, this.columns.RowIndex, problem, _function);
        }
        Functions.Function1 _function_1 = it -> this.translate((Enumerator)it.getSeverity());
        this.fill(instance, this.columns.Severity, problem, _function_1);
        Functions.Function1 _function_2 = it -> it.getType();
        this.fill(instance, this.columns.ProblemType, problem, _function_2);
        int _lineNumber = problem.getLineNumber();
        boolean bl2 = _tripleNotEquals_1 = _lineNumber != 0;
        if (_tripleNotEquals_1) {
            Functions.Function1 _function_3 = it -> it.getLineNumber();
            this.fillNumeric(instance, this.columns.LineNumber, problem, _function_3);
        }
        Functions.Function1 _function_4 = it -> it.getObjectArt();
        this.fill(instance, this.columns.ObjectType, problem, _function_4);
        Functions.Function1 _function_5 = it -> it.getAttributeName();
        this.fill(instance, this.columns.AttributeGroup, problem, _function_5);
        Functions.Function1 _function_6 = it -> {
            ObjectScope _objectScope = it.getObjectScope();
            String _literal = null;
            if (_objectScope != null) {
                _literal = _objectScope.getLiteral();
            }
            return _literal;
        };
        this.fill(instance, this.columns.ObjectScope, problem, _function_6);
        Functions.Function1 _function_7 = it -> {
            ObjectState _objectState = it.getObjectState();
            String _literal = null;
            if (_objectState != null) {
                _literal = _objectState.getLiteral();
            }
            return _literal;
        };
        this.fill(instance, this.columns.ObjectState, problem, _function_7);
        Functions.Function1 _function_8 = it -> it.getMessage();
        this.fill(instance, this.columns.Message, problem, _function_8);
    }

    public String translate(Enumerator enumerator) {
        if (enumerator == null) {
            return null;
        }
        return this.enumTranslationService.translate(enumerator).getAlternative();
    }

    public List<ColumnDescriptor> getExcludeColumns() {
        return this.excludeColumns;
    }

    public ColumnDescriptor getIndexColumn() {
        return this.columns.RowIndex;
    }

    public List<ValidationProblem> getProblems(PlazReport report) {
        return report.getEntries();
    }

    public ColumnDescriptor getMessagesColumn() {
        return this.columns.Message;
    }
}

