/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.feature.plazmodel.check;

import com.google.common.collect.Streams;
import java.math.BigDecimal;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.set.feature.plazmodel.check.AbstractPlazContainerCheck;
import org.eclipse.set.feature.plazmodel.check.PlazCheck;
import org.eclipse.set.model.planpro.Basisobjekte.Bereich_Objekt;
import org.eclipse.set.model.planpro.Basisobjekte.Bereich_Objekt_Teilbereich_AttributeGroup;
import org.eclipse.set.model.plazmodel.PlazError;
import org.eclipse.set.model.plazmodel.PlazFactory;
import org.eclipse.set.model.validationreport.ValidationSeverity;
import org.eclipse.set.ppmodel.extensions.EObjectExtensions;
import org.eclipse.set.ppmodel.extensions.container.MultiContainer_AttributeGroup;
import org.osgi.service.component.annotations.Component;

@Component
public class TeilbereichOverlapCheck
extends AbstractPlazContainerCheck
implements PlazCheck {
    @Override
    public String checkType() {
        return "\u00dcberlappende Teilbereiche";
    }

    @Override
    public String getDescription() {
        return "Teilbereichsgrenzen der LST-Objekte sind plausibel";
    }

    @Override
    public String getGeneralErrMsg() {
        return "F\u00fcr das Bereichsobjekt {Objektart} {OBJEKT_GUID} sind mehrere \u00fcberlappende/\u200bmehrere \u200bTeilbereiche \u200bauf \u200bder TOP-Kante {TOP_KANTE_GUID} definiert.";
    }

    @Override
    protected List<PlazError> run(MultiContainer_AttributeGroup container) {
        return Streams.stream((Iterable)container.getBereichObjekt()).flatMap(bo -> {
            List<List> sameTopKanteTeilBereich = bo.getBereichObjektTeilbereich().stream().filter(botb -> EObjectExtensions.getNullableObject((Object)botb, e -> e.getIDTOPKante().getValue()).isPresent()).collect(Collectors.groupingBy(botb -> botb.getIDTOPKante().getValue())).values().stream().filter(l -> l.size() > 1).toList();
            HashSet overlapBotb = new HashSet();
            sameTopKanteTeilBereich.forEach(botbs -> {
                int i = 0;
                while (i < botbs.size()) {
                    int j = i + 1;
                    while (j < botbs.size()) {
                        if (TeilbereichOverlapCheck.isTeilbereichOverlap((Bereich_Objekt_Teilbereich_AttributeGroup)botbs.get(i), (Bereich_Objekt_Teilbereich_AttributeGroup)botbs.get(j))) {
                            overlapBotb.add((Bereich_Objekt_Teilbereich_AttributeGroup)botbs.get(i));
                            overlapBotb.add((Bereich_Objekt_Teilbereich_AttributeGroup)botbs.get(j));
                        }
                        ++j;
                    }
                    ++i;
                }
            });
            if (!overlapBotb.isEmpty()) {
                return overlapBotb.stream().map(botb -> this.createPlaZError((Bereich_Objekt)bo, (Bereich_Objekt_Teilbereich_AttributeGroup)botb));
            }
            return null;
        }).filter(Objects::nonNull).toList();
    }

    private static boolean isTeilbereichOverlap(Bereich_Objekt_Teilbereich_AttributeGroup botb1, Bereich_Objekt_Teilbereich_AttributeGroup botb2) {
        if (botb1.getIDTOPKante().getValue() != botb2.getIDTOPKante().getValue()) {
            return false;
        }
        BigDecimal limitA1 = botb1.getBegrenzungA().getWert();
        BigDecimal limitB1 = botb1.getBegrenzungB().getWert();
        BigDecimal limitA2 = botb2.getBegrenzungA().getWert();
        BigDecimal limitB2 = botb2.getBegrenzungB().getWert();
        return limitA1.compareTo(limitB2) < 0 && limitA1.compareTo(limitA2) > 0 || limitB1.compareTo(limitB2) < 0 && limitB1.compareTo(limitA2) > 0;
    }

    private PlazError createPlaZError(Bereich_Objekt bo, Bereich_Objekt_Teilbereich_AttributeGroup botb) {
        PlazError plazError = PlazFactory.eINSTANCE.createPlazError();
        plazError.setSeverity(ValidationSeverity.ERROR);
        plazError.setMessage(this.transformErrorMsg(Map.of("Objektart", bo.eClass().getName(), "OBJEKT_GUID", bo.getIdentitaet().getWert(), "TOP_KANTE_GUID", botb.getIDTOPKante().getWert())));
        plazError.setType(this.checkType());
        plazError.setObject((EObject)botb);
        return plazError;
    }
}

