/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.feature.plazmodel.check;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.text.StringSubstitutor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.set.basis.graph.TopPath;
import org.eclipse.set.basis.graph.TopPoint;
import org.eclipse.set.core.services.graph.BankService;
import org.eclipse.set.core.services.graph.TopologicalGraphService;
import org.eclipse.set.feature.plazmodel.check.AbstractPlazContainerCheck;
import org.eclipse.set.feature.plazmodel.check.PlazCheck;
import org.eclipse.set.model.planpro.Basisobjekte.Identitaet_TypeClass;
import org.eclipse.set.model.planpro.Basisobjekte.Punkt_Objekt;
import org.eclipse.set.model.planpro.Geodaten.Ueberhoehung;
import org.eclipse.set.model.planpro.Geodaten.Ueberhoehungslinie;
import org.eclipse.set.model.planpro.Verweise.ID_Ueberhoehung_TypeClass;
import org.eclipse.set.model.plazmodel.PlazError;
import org.eclipse.set.model.plazmodel.PlazFactory;
import org.eclipse.set.model.validationreport.ValidationSeverity;
import org.eclipse.set.ppmodel.extensions.container.MultiContainer_AttributeGroup;
import org.eclipse.set.utils.ToolboxConfiguration;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;
import org.osgi.service.event.EventHandler;

@Component(property={"event.topics=bankingservice/done"})
public class BankValues
extends AbstractPlazContainerCheck
implements PlazCheck,
EventHandler {
    @Reference
    private BankService bankService;
    @Reference
    private TopologicalGraphService topologicalService;
    @Reference
    private EventAdmin eventAdmin;

    @Override
    public List<PlazError> run(MultiContainer_AttributeGroup container) {
        boolean _not;
        boolean _isFindBankingComplete = this.bankService.isFindBankingComplete();
        boolean bl = _not = !_isFindBankingComplete;
        if (_not) {
            return List.of(this.createProcessingWarning());
        }
        Functions.Function1 _function = it -> {
            BankService.BankingInformation _findTOPBanking = this.bankService.findTOPBanking(it);
            return _findTOPBanking == null;
        };
        Functions.Function1 _function_1 = it -> {
            double _bankLineTopOffsetLimit;
            double _doubleValue;
            double _plus;
            double _plus_1;
            Ueberhoehung _value_3;
            TopPoint end;
            boolean _tripleEquals;
            BigDecimal bankLength = it.getUeberhoehungslinieAllg().getUeberhoehungslinieLaenge().getWert();
            boolean _or = false;
            ID_Ueberhoehung_TypeClass _iDUeberhoehungA = it.getIDUeberhoehungA();
            Ueberhoehung _value = null;
            if (_iDUeberhoehungA != null) {
                _value = _iDUeberhoehungA.getValue();
            }
            boolean bl = _tripleEquals = _value == null;
            if (_tripleEquals) {
                _or = true;
            } else {
                boolean _tripleEquals_1;
                ID_Ueberhoehung_TypeClass _iDUeberhoehungB = it.getIDUeberhoehungB();
                Ueberhoehung _value_1 = null;
                if (_iDUeberhoehungB != null) {
                    _value_1 = _iDUeberhoehungB.getValue();
                }
                _or = _tripleEquals_1 = _value_1 == null;
            }
            if (_or) {
                return this.createError((Ueberhoehungslinie)it, "Die \u00dcberh\u00f6hungslinie {GUID} hat entweder keine Ueberhoehung_A oder keine Ueberhoehung_B.", Map.of("GUID", it.getIdentitaet().getWert()));
            }
            Ueberhoehung _value_2 = it.getIDUeberhoehungA().getValue();
            TopPoint begin = new TopPoint((Punkt_Objekt)_value_2);
            List paths = this.topologicalService.findAllPathsBetween(begin, end = new TopPoint((Punkt_Objekt)(_value_3 = it.getIDUeberhoehungB().getValue())), (int)(_plus_1 = (_plus = (_doubleValue = bankLength.doubleValue()) + (_bankLineTopOffsetLimit = ToolboxConfiguration.getBankLineTopOffsetLimit())) + 1.0));
            boolean _isEmpty = paths.isEmpty();
            if (_isEmpty) {
                Identitaet_TypeClass _identitaet = it.getIdentitaet();
                String _wert = null;
                if (_identitaet != null) {
                    _wert = _identitaet.getWert();
                }
                return this.createError((Ueberhoehungslinie)it, "Es konnte kein topologischer Pfad f\u00fcr die \u00dcberh\u00f6hungslinie {GUID} gefunden werden.", Map.of("GUID", _wert));
            }
            Functions.Function1 _function_2 = path -> path.getDistance(end).isPresent();
            Functions.Function2 _function_3 = (p1, p2) -> {
                BigDecimal _length = p1.length();
                BigDecimal _length_1 = p2.length();
                return p1;
            };
            TopPath completeShortesPath = (TopPath)IterableExtensions.reduce((Iterable)IterableExtensions.filter((Iterable)paths, (Functions.Function1)_function_2), (Functions.Function2)_function_3);
            if (completeShortesPath != null && Math.abs(bankLength.subtract(completeShortesPath.length()).doubleValue()) > ToolboxConfiguration.getBankLineTopOffsetLimit()) {
                Identitaet_TypeClass _identitaet_1 = it.getIdentitaet();
                String _wert_1 = null;
                if (_identitaet_1 != null) {
                    _wert_1 = _identitaet_1.getWert();
                }
                BigDecimal _length = null;
                if (completeShortesPath != null) {
                    _length = completeShortesPath.length();
                }
                String _string = null;
                if (_length != null) {
                    _string = _length.toString();
                }
                return this.createError((Ueberhoehungslinie)it, "Die L\u00e4nge des topologischen Pfads ({PFAD}) f\u00fcr die \u00dcberh\u00f6hungslinie {GUID} weicht von der L\u00e4nge der \u00dcberh\u00f6hungslinie ({UEBERHOEHUNG}) ab.", Map.of("GUID", _wert_1, "PFAD", _string, "UEBERHOEHUNG", bankLength.toString()));
            }
            Functions.Function2 _function_4 = (p1, p2) -> {
                BigDecimal _length_1 = p1.length();
                BigDecimal _length_2 = p2.length();
                return p1;
            };
            TopPath longestPath = (TopPath)IterableExtensions.reduce((Iterable)paths, (Functions.Function2)_function_4);
            Identitaet_TypeClass _identitaet_2 = it.getIdentitaet();
            String _wert_2 = null;
            if (_identitaet_2 != null) {
                _wert_2 = _identitaet_2.getWert();
            }
            BigDecimal _length_1 = null;
            if (longestPath != null) {
                _length_1 = longestPath.length();
            }
            String _string_1 = null;
            if (_length_1 != null) {
                _string_1 = _length_1.toString();
            }
            return this.createError((Ueberhoehungslinie)it, "Es konnte kein passender topologischer Pfad (gesucht bis {PFAD}) f\u00fcr die \u00dcberh\u00f6hungslinie {GUID} mit entsprechender L\u00e4nge ({UEBERHOEHUNG}) gefunden werden.", Map.of("GUID", _wert_2, "PFAD", _string_1, "UEBERHOEHUNG", bankLength.toString()));
        };
        return IterableExtensions.toList((Iterable)IterableExtensions.filterNull((Iterable)IterableExtensions.map((Iterable)IterableExtensions.filter((Iterable)container.getUeberhoehungslinie(), (Functions.Function1)_function), (Functions.Function1)_function_1)));
    }

    private PlazError createError(Ueberhoehungslinie object, String message, Map<String, String> data) {
        PlazError err = PlazFactory.eINSTANCE.createPlazError();
        err.setMessage(StringSubstitutor.replace((Object)message, data, (String)"{", (String)"}"));
        err.setType(this.checkType());
        err.setObject((EObject)object);
        return err;
    }

    private PlazError createProcessingWarning() {
        PlazError err = PlazFactory.eINSTANCE.createPlazError();
        err.setType(this.checkType());
        err.setMessage(BankValues.getProcessingWarningMsg());
        err.setSeverity(ValidationSeverity.WARNING);
        return err;
    }

    @Override
    public String checkType() {
        return "\u00dcberh\u00f6hungslinie";
    }

    @Override
    public String getDescription() {
        return "Topologische Pfade konnten f\u00fcr \u00dcberh\u00f6hungslinien gefunden werden.";
    }

    @Override
    public String getGeneralErrMsg() {
        return "Es gibt \u00dcberh\u00f6hungslinien mit fehlerhaften topologischen Pfaden.";
    }

    public static String getProcessingWarningMsg() {
        return "Die Suchung nach Topologischen Pfade for \u00dcberh\u00f6hungslinien ist noch nicht beendet.";
    }

    public void handleEvent(Event event) {
        HashMap properties = CollectionLiterals.newHashMap();
        properties.put("org.eclipse.e4.data", this.getClass());
        Event _event = new Event("plazmodel/check", (Map)properties);
        this.eventAdmin.sendEvent(_event);
    }
}

