/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.core.dialogservice;

import java.io.FileNotFoundException;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.AccessDeniedException;
import java.nio.file.FileSystemException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.function.Consumer;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.set.basis.exceptions.ErrorStatus;
import org.eclipse.set.basis.exceptions.FileExportException;
import org.eclipse.set.basis.exceptions.IllegalReference;
import org.eclipse.set.basis.exceptions.NotWritable;
import org.eclipse.set.basis.files.ToolboxFileFilter;
import org.eclipse.set.core.Messages;
import org.eclipse.set.core.dialogservice.ErrorStatusImpl;
import org.eclipse.set.model.planpro.BasisTypen.Zeiger_TypeClass;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.StringExtensions;
import org.eclipse.xtext.xbase.lib.XbaseGenerated;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class ExceptionTransformation {
    private final Messages messages;
    private Bundle bundle;
    private String technicalMessage;
    private final HashMap<ArrayList<?>, ErrorStatus> _createCache_transform = CollectionLiterals.newHashMap();
    private final HashMap<ArrayList<?>, IStatus> _createCache_transformToStatus = CollectionLiterals.newHashMap();
    private final HashMap<ArrayList<?>, IStatus> _createCache_transformToStatus_1 = CollectionLiterals.newHashMap();
    private final HashMap<ArrayList<?>, IStatus> _createCache_transformToStatus_2 = CollectionLiterals.newHashMap();
    private final HashMap<ArrayList<?>, IStatus> _createCache_transformToStatus_3 = CollectionLiterals.newHashMap();
    private final HashMap<ArrayList<?>, IStatus> _createCache_transformToStatus_4 = CollectionLiterals.newHashMap();

    public ExceptionTransformation(Messages messages) {
        this.messages = messages;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ErrorStatus transform(Throwable e, String technicalMessage) {
        ErrorStatusImpl _result;
        ArrayList _cacheKey = CollectionLiterals.newArrayList((Object[])new Serializable[]{e, technicalMessage});
        HashMap<ArrayList<?>, ErrorStatus> hashMap = this._createCache_transform;
        synchronized (hashMap) {
            ErrorStatusImpl _errorStatusImpl;
            if (this._createCache_transform.containsKey(_cacheKey)) {
                return this._createCache_transform.get(_cacheKey);
            }
            _result = _errorStatusImpl = new ErrorStatusImpl();
            this._createCache_transform.put(_cacheKey, _result);
        }
        this._init_transform(_result, e, technicalMessage);
        return _result;
    }

    private void _init_transform(ErrorStatusImpl it, Throwable e, String technicalMessage) {
        this.bundle = FrameworkUtil.getBundle(this.getClass());
        this.technicalMessage = technicalMessage;
        it.setErrorTitle(this.transformToTitle(e));
        it.setUserMessage(this.transformToUserMessage(e));
        it.setStatus(this.transformToStatus(e, false));
    }

    private String _transformToTitle(Void e) {
        return this.messages.ExceptionTransformation_DefaultTitle;
    }

    private String _transformToTitle(Throwable e) {
        return this.messages.ExceptionTransformation_DefaultTitle;
    }

    private String _transformToTitle(FileExportException e) {
        return this.messages.ExceptionTransformation_ExportTitle;
    }

    private String _transformToTitle(InvocationTargetException e) {
        return this.transformToTitle(e.getCause());
    }

    private String _transformToTitle(ToolboxFileFilter.InvalidFilterFilename e) {
        return this.messages.ExceptionTransformation_InvalidFilterFilenameTitle;
    }

    private String _transformToUserMessage(Void e) {
        return null;
    }

    private String _transformToUserMessage(Throwable e) {
        return this.messages.ExceptionTransformation_DefaultMessage;
    }

    private String _transformToUserMessage(FileExportException e) {
        return String.format(this.messages.ExceptionTransformation_ExportMessagePattern, e.getExportTarget());
    }

    private String _transformToUserMessage(InvocationTargetException e) {
        return this.transformToUserMessage(e.getCause());
    }

    private String _transformToUserMessage(ToolboxFileFilter.InvalidFilterFilename e) {
        return String.format(this.messages.ExceptionTransformation_InvalidFilterFilenameMessagePattern, ToolboxFileFilter.getFilterExtensions((List)e.getExtensions()));
    }

    private String _transformToUserMessage(NullPointerException e) {
        return this.messages.ExceptionTransformation_NullPointerException_Message;
    }

    private String _transformToUserMessage(FileNotFoundException e) {
        return this.messages.ExceptionTransformation_FileNotFoundException_Message;
    }

    private String _transformToUserMessage(AccessDeniedException e) {
        return this.messages.ExceptionTransformation_FileNotFoundException_Message;
    }

    private String _transformToUserMessage(FileSystemException e) {
        return this.messages.ExceptionTransformation_FileNotFoundException_Message;
    }

    private String _transformToUserMessage(IllegalReference e) {
        return String.format(this.messages.ExceptionTransformation_IllegalReference_MessagePattern, this.transformToObject(e));
    }

    private String _transformToTechnicalMessage(Void e, boolean showType) {
        if (this.technicalMessage != null) {
            return this.technicalMessage;
        }
        return this.messages.ExceptionTransformation_NoMessage;
    }

    private String _transformToTechnicalMessage(Throwable e, boolean showType) {
        boolean _not;
        if (this.technicalMessage != null) {
            return this.technicalMessage;
        }
        if (showType) {
            return e.getClass().getSimpleName();
        }
        String message = this.messages.ExceptionTransformation_NoMessage;
        boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)e.getMessage());
        boolean bl = _not = !_isNullOrEmpty;
        if (_not) {
            message = e.getMessage();
        }
        return message;
    }

    private String _transformToTechnicalMessage(AccessDeniedException e, boolean showType) {
        return String.format(this.messages.ExceptionTransformation_AccessDeniedPattern, e.getMessage());
    }

    private String _transformToTechnicalMessage(InvocationTargetException e, boolean showType) {
        if (this.technicalMessage != null) {
            return this.technicalMessage;
        }
        return this.transformToTechnicalMessage(e.getCause(), showType);
    }

    private String _transformToTechnicalMessage(FileExportException e, boolean showType) {
        if (this.technicalMessage != null) {
            return this.technicalMessage;
        }
        if (showType) {
            return e.getClass().getSimpleName();
        }
        return this.transformToTechnicalMessage(e.getException(), showType);
    }

    private String _transformToTechnicalMessage(NotWritable e, boolean showType) {
        if (this.technicalMessage != null) {
            return this.technicalMessage;
        }
        if (showType) {
            return e.getClass().getSimpleName();
        }
        return String.format(this.messages.ExceptionTransformation_NotWriteablePattern, e.getFilePath());
    }

    private String _transformToTechnicalMessage(IllegalReference e, boolean showType) {
        if (this.technicalMessage != null) {
            return this.technicalMessage;
        }
        if (showType) {
            return e.getClass().getSimpleName();
        }
        return String.format(this.messages.ExceptionTransformation_IllegalReference_DetailMessagePattern, this.transformToObject(e), this.transformToReference(e), this.transformToValue(e));
    }

    private String _transformToTechnicalMessage(IndexOutOfBoundsException e, boolean showType) {
        if (this.technicalMessage != null) {
            return this.technicalMessage;
        }
        if (showType) {
            return e.getClass().getSimpleName();
        }
        return this.messages.ExceptionTransformation_IndexOutOfBoundsException_DetailMessage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IStatus _transformToStatus(Void e, boolean showType) {
        MultiStatus _result;
        ArrayList _cacheKey = CollectionLiterals.newArrayList((Object[])new Object[]{e, showType});
        HashMap<ArrayList<?>, IStatus> hashMap = this._createCache_transformToStatus;
        synchronized (hashMap) {
            MultiStatus _multiStatus;
            if (this._createCache_transformToStatus.containsKey(_cacheKey)) {
                return this._createCache_transformToStatus.get(_cacheKey);
            }
            String _symbolicName = this.bundle.getSymbolicName();
            String _transformToTechnicalMessage = this.transformToTechnicalMessage(null, showType);
            _result = _multiStatus = new MultiStatus(_symbolicName, 0, _transformToTechnicalMessage, null);
            this._createCache_transformToStatus.put(_cacheKey, (IStatus)_result);
        }
        this._init_transformToStatus(_result, e, showType);
        return _result;
    }

    private void _init_transformToStatus(MultiStatus it, Void e, boolean showType) {
        String _symbolicName = this.bundle.getSymbolicName();
        StringConcatenation _builder = new StringConcatenation();
        _builder.append(this.messages.ExceptionTransformation_ExceptionName);
        _builder.append(": No exception provided.");
        Status _status = new Status(4, _symbolicName, _builder.toString());
        it.add((IStatus)_status);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IStatus _transformToStatus(Throwable e, boolean showType) {
        MultiStatus _result;
        ArrayList _cacheKey = CollectionLiterals.newArrayList((Object[])new Serializable[]{e, Boolean.valueOf(showType)});
        HashMap<ArrayList<?>, IStatus> hashMap = this._createCache_transformToStatus_1;
        synchronized (hashMap) {
            MultiStatus _multiStatus;
            if (this._createCache_transformToStatus_1.containsKey(_cacheKey)) {
                return this._createCache_transformToStatus_1.get(_cacheKey);
            }
            String _symbolicName = this.bundle.getSymbolicName();
            String _transformToTechnicalMessage = this.transformToTechnicalMessage(e, showType);
            _result = _multiStatus = new MultiStatus(_symbolicName, 0, _transformToTechnicalMessage, e);
            this._createCache_transformToStatus_1.put(_cacheKey, (IStatus)_result);
        }
        this._init_transformToStatus_1(_result, e, showType);
        return _result;
    }

    private void _init_transformToStatus_1(MultiStatus it, Throwable e, boolean showType) {
        MultiStatus status = it;
        StackTraceElement[] stackTrace = e.getStackTrace();
        String _symbolicName = this.bundle.getSymbolicName();
        StringConcatenation _builder = new StringConcatenation();
        _builder.append(this.messages.ExceptionTransformation_ExceptionName);
        _builder.append(": ");
        String _simpleName = e.getClass().getSimpleName();
        _builder.append(_simpleName);
        Status _status = new Status(4, _symbolicName, _builder.toString());
        it.add((IStatus)_status);
        Consumer<StackTraceElement> _function = it_1 -> status.add(this.transformToStatus((Serializable)it_1, showType));
        ((List)Conversions.doWrapArray((Object)stackTrace)).forEach(_function);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IStatus _transformToStatus(StackTraceElement t, boolean showType) {
        Status _result;
        ArrayList _cacheKey = CollectionLiterals.newArrayList((Object[])new Serializable[]{t, Boolean.valueOf(showType)});
        HashMap<ArrayList<?>, IStatus> hashMap = this._createCache_transformToStatus_2;
        synchronized (hashMap) {
            Status _status;
            if (this._createCache_transformToStatus_2.containsKey(_cacheKey)) {
                return this._createCache_transformToStatus_2.get(_cacheKey);
            }
            String _symbolicName = this.bundle.getSymbolicName();
            String _string = t.toString();
            _result = _status = new Status(4, _symbolicName, _string);
            this._createCache_transformToStatus_2.put(_cacheKey, (IStatus)_result);
        }
        this._init_transformToStatus_2(_result, t, showType);
        return _result;
    }

    private void _init_transformToStatus_2(Status it, StackTraceElement t, boolean showType) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IStatus _transformToStatus(InvocationTargetException e, boolean showType) {
        MultiStatus _result;
        ArrayList _cacheKey = CollectionLiterals.newArrayList((Object[])new Serializable[]{e, Boolean.valueOf(showType)});
        HashMap<ArrayList<?>, IStatus> hashMap = this._createCache_transformToStatus_3;
        synchronized (hashMap) {
            MultiStatus _multiStatus;
            if (this._createCache_transformToStatus_3.containsKey(_cacheKey)) {
                return this._createCache_transformToStatus_3.get(_cacheKey);
            }
            String _symbolicName = this.bundle.getSymbolicName();
            String _transformToTechnicalMessage = this.transformToTechnicalMessage(e, showType);
            _result = _multiStatus = new MultiStatus(_symbolicName, 0, _transformToTechnicalMessage, (Throwable)e);
            this._createCache_transformToStatus_3.put(_cacheKey, (IStatus)_result);
        }
        this._init_transformToStatus_3(_result, e, showType);
        return _result;
    }

    private void _init_transformToStatus_3(MultiStatus it, InvocationTargetException e, boolean showType) {
        it.add(this.transformToStatus(e.getCause(), true));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IStatus _transformToStatus(FileExportException e, boolean showType) {
        MultiStatus _result;
        ArrayList _cacheKey = CollectionLiterals.newArrayList((Object[])new Serializable[]{e, Boolean.valueOf(showType)});
        HashMap<ArrayList<?>, IStatus> hashMap = this._createCache_transformToStatus_4;
        synchronized (hashMap) {
            MultiStatus _multiStatus;
            if (this._createCache_transformToStatus_4.containsKey(_cacheKey)) {
                return this._createCache_transformToStatus_4.get(_cacheKey);
            }
            String _symbolicName = this.bundle.getSymbolicName();
            String _transformToTechnicalMessage = this.transformToTechnicalMessage((Throwable)e, showType);
            _result = _multiStatus = new MultiStatus(_symbolicName, 0, _transformToTechnicalMessage, (Throwable)e);
            this._createCache_transformToStatus_4.put(_cacheKey, (IStatus)_result);
        }
        this._init_transformToStatus_4(_result, e, showType);
        return _result;
    }

    private void _init_transformToStatus_4(MultiStatus it, FileExportException e, boolean showType) {
        it.add(this.transformToStatus(e.getException(), true));
    }

    private String transformToObject(IllegalReference e) {
        return e.getObject().eClass().getName();
    }

    private String transformToReference(IllegalReference e) {
        return e.getReference().getName();
    }

    private String _transformToValue(Object object) {
        return object.toString();
    }

    private String _transformToValue(Void e) {
        return this.messages.ExceptionTransformation_MissingReference;
    }

    private String _transformToValue(Zeiger_TypeClass p) {
        return p.getWert().toString();
    }

    private String _transformToValue(IllegalReference e) {
        return this.transformToValue(e.getObject().eGet((EStructuralFeature)e.getReference()));
    }

    @XbaseGenerated
    private String transformToTitle(Throwable e) {
        if (e instanceof InvocationTargetException) {
            return this._transformToTitle((InvocationTargetException)e);
        }
        if (e instanceof FileExportException) {
            return this._transformToTitle((FileExportException)e);
        }
        if (e instanceof ToolboxFileFilter.InvalidFilterFilename) {
            return this._transformToTitle((ToolboxFileFilter.InvalidFilterFilename)e);
        }
        if (e != null) {
            return this._transformToTitle(e);
        }
        return this._transformToTitle((Void)null);
    }

    @XbaseGenerated
    private String transformToUserMessage(Throwable e) {
        if (e instanceof AccessDeniedException) {
            return this._transformToUserMessage((AccessDeniedException)e);
        }
        if (e instanceof FileNotFoundException) {
            return this._transformToUserMessage((FileNotFoundException)e);
        }
        if (e instanceof NullPointerException) {
            return this._transformToUserMessage((NullPointerException)e);
        }
        if (e instanceof InvocationTargetException) {
            return this._transformToUserMessage((InvocationTargetException)e);
        }
        if (e instanceof FileSystemException) {
            return this._transformToUserMessage((FileSystemException)e);
        }
        if (e instanceof FileExportException) {
            return this._transformToUserMessage((FileExportException)e);
        }
        if (e instanceof IllegalReference) {
            return this._transformToUserMessage((IllegalReference)e);
        }
        if (e instanceof ToolboxFileFilter.InvalidFilterFilename) {
            return this._transformToUserMessage((ToolboxFileFilter.InvalidFilterFilename)e);
        }
        if (e != null) {
            return this._transformToUserMessage(e);
        }
        return this._transformToUserMessage((Void)null);
    }

    @XbaseGenerated
    private String transformToTechnicalMessage(Throwable e, boolean showType) {
        if (e instanceof AccessDeniedException) {
            return this._transformToTechnicalMessage((AccessDeniedException)e, showType);
        }
        if (e instanceof IndexOutOfBoundsException) {
            return this._transformToTechnicalMessage((IndexOutOfBoundsException)e, showType);
        }
        if (e instanceof InvocationTargetException) {
            return this._transformToTechnicalMessage((InvocationTargetException)e, showType);
        }
        if (e instanceof FileExportException) {
            return this._transformToTechnicalMessage((FileExportException)e, showType);
        }
        if (e instanceof IllegalReference) {
            return this._transformToTechnicalMessage((IllegalReference)e, showType);
        }
        if (e instanceof NotWritable) {
            return this._transformToTechnicalMessage((NotWritable)e, showType);
        }
        if (e != null) {
            return this._transformToTechnicalMessage(e, showType);
        }
        if (e == null) {
            return this._transformToTechnicalMessage((Void)null, showType);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(e, showType).toString());
    }

    @XbaseGenerated
    private IStatus transformToStatus(Serializable e, boolean showType) {
        if (e instanceof InvocationTargetException) {
            return this._transformToStatus((InvocationTargetException)e, showType);
        }
        if (e instanceof FileExportException) {
            return this._transformToStatus((FileExportException)e, showType);
        }
        if (e instanceof StackTraceElement) {
            return this._transformToStatus((StackTraceElement)e, showType);
        }
        if (e instanceof Throwable) {
            return this._transformToStatus((Throwable)e, showType);
        }
        if (e == null) {
            return this._transformToStatus((Void)null, showType);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(e, showType).toString());
    }

    @XbaseGenerated
    private String transformToValue(Object e) {
        if (e instanceof IllegalReference) {
            return this._transformToValue((IllegalReference)e);
        }
        if (e instanceof Zeiger_TypeClass) {
            return this._transformToValue((Zeiger_TypeClass)e);
        }
        if (e == null) {
            return this._transformToValue((Void)null);
        }
        return this._transformToValue(e);
    }
}

