/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.feature.export.parts;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.inject.Inject;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.emfcloud.jackson.module.EMFModule;
import org.eclipse.set.basis.files.ToolboxFileFilterBuilder;
import org.eclipse.set.feature.overviewplan.transformator.OverviewplanTransformator;
import org.eclipse.set.feature.siteplan.json.SiteplanEObjectSerializer;
import org.eclipse.set.feature.siteplan.transform.SiteplanTransformator;
import org.eclipse.set.model.siteplan.Siteplan;
import org.eclipse.set.utils.BasePart;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Listener;

public class SiteplanModelExportPart
extends BasePart {
    @Inject
    IEclipseContext context;

    protected void createView(Composite parent) {
        Button siteplanExport = new Button(parent, 8);
        siteplanExport.setText("Lageplanmodell exportieren (JSON)");
        siteplanExport.addListener(13, this.selectionListerner(ToolboxFileFilterBuilder.forName((String)"Lageplan"), Path.of("siteplan.json", new String[0]), path -> this.writeJson((Path)path, t -> ((SiteplanTransformator)t.get(SiteplanTransformator.class)).transform(this.getModelSession()))));
        Button overviewplanExport = new Button(parent, 8);
        overviewplanExport.setText("Overviewmodell exportieren (JSON)");
        overviewplanExport.addListener(13, this.selectionListerner(ToolboxFileFilterBuilder.forName((String)"Uebersichtplan"), Path.of("overviewplan.json", new String[0]), path -> this.writeJson((Path)path, t -> {
            OverviewplanTransformator overviewplanTransformator = (OverviewplanTransformator)t.get(OverviewplanTransformator.class);
            return overviewplanTransformator.transform(this.getModelSession());
        })));
    }

    private Listener selectionListerner(ToolboxFileFilterBuilder fileFilter, Path outPath, Consumer<Path> writeJsonConsumer) {
        return event -> this.getDialogService().saveFileDialog(this.getToolboxShell(), List.of(fileFilter.add(new String[]{"json"}).create()), outPath).ifPresent(path -> {
            writeJsonConsumer.accept((Path)path);
            this.getDialogService().openDirectoryAfterExport(this.getToolboxShell(), path.getParent());
        });
    }

    private void writeJson(Path path, Function<IEclipseContext, Siteplan> transformator) {
        Siteplan siteplan = transformator.apply(this.context);
        ObjectMapper mapper = new ObjectMapper();
        EMFModule module = new EMFModule();
        module.configure(EMFModule.Feature.OPTION_SERIALIZE_TYPE, false);
        module.configure(EMFModule.Feature.OPTION_SERIALIZE_DEFAULT_VALUE, true);
        mapper.registerModule((Module)module);
        mapper.registerModule((Module)SiteplanEObjectSerializer.getModule((EMFModule)module));
        try {
            String json = mapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)siteplan);
            Files.writeString(path, (CharSequence)json, new OpenOption[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

