/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.feature.export.fop;

import java.util.ArrayList;
import java.util.List;
import org.apache.fop.apps.FOPException;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.apps.io.InternalResourceResolver;
import org.apache.fop.fonts.EmbedFontInfo;
import org.apache.fop.fonts.EmbeddingMode;
import org.apache.fop.fonts.EncodingMode;
import org.apache.fop.fonts.FontAdder;
import org.apache.fop.fonts.FontCollection;
import org.apache.fop.fonts.FontEventAdapter;
import org.apache.fop.fonts.FontEventListener;
import org.apache.fop.fonts.FontInfo;
import org.apache.fop.fonts.FontManager;
import org.apache.fop.fonts.FontManagerConfigurator;
import org.apache.fop.fonts.FontTriplet;
import org.apache.fop.fonts.FontUris;
import org.apache.fop.render.RendererConfig;
import org.apache.fop.render.pdf.PDFRendererConfigurator;
import org.eclipse.set.core.services.font.FontService;

public class FopPDFRendererConfigurator
extends PDFRendererConfigurator {
    private final FontService fontService;

    public FopPDFRendererConfigurator(FOUserAgent userAgent, RendererConfig.RendererConfigParser rendererConfigParser, FontService fontService) {
        super(userAgent, rendererConfigParser);
        this.fontService = fontService;
    }

    private static int toFontWeight(String weight) {
        switch (weight) {
            case "light": {
                return 400;
            }
            case "normal": {
                return 400;
            }
            case "bold": {
                return 700;
            }
            case "extra bold": {
                return 800;
            }
        }
        throw new IllegalArgumentException("Invalid font weight");
    }

    protected FontCollection getCustomFontCollection(InternalResourceResolver resolver, String mimeType) throws FOPException {
        ArrayList fontList = new ArrayList();
        this.fontService.getFopFonts().forEach(font -> {
            FontUris fontUri = new FontUris(font.path().toUri(), null);
            List<FontTriplet> fontTriplets = List.of(new FontTriplet(font.name(), font.style(), FopPDFRendererConfigurator.toFontWeight(font.weight())));
            fontList.add(new EmbedFontInfo(fontUri, true, false, fontTriplets, null, EncodingMode.AUTO, EmbeddingMode.SUBSET, false, false, true));
        });
        return this.createCollectionFromFontList(resolver, fontList);
    }

    protected List<FontCollection> getDefaultFontCollection() {
        List fontsCollections = super.getDefaultFontCollection();
        ArrayList systemFonts = new ArrayList();
        FontManager fontManager = this.userAgent.getFontManager();
        FontEventAdapter eventAdapter = new FontEventAdapter(this.userAgent.getEventBroadcaster());
        FontAdder fontAdder = new FontAdder(fontManager, fontManager.getResourceResolver(), (FontEventListener)eventAdapter);
        try {
            fontManager.autoDetectFonts(true, fontAdder, false, (FontEventListener)eventAdapter, systemFonts);
            fontsCollections.add(this.createCollectionFromFontList(this.userAgent.getResourceResolver(), systemFonts));
        }
        catch (FOPException e) {
            throw new RuntimeException(e);
        }
        return fontsCollections;
    }

    public void setupFontInfo(String mimeType, FontInfo fontInfo) throws FOPException {
        FontManager fontManager = this.userAgent.getFontManager();
        fontManager.setReferencedFontsMatcher(FontManagerConfigurator.createFontsMatcher(List.of("Arial.*"), (boolean)false));
        super.setupFontInfo(mimeType, fontInfo);
    }
}

