/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.feature.plazmodel.table;

import java.nio.file.Path;
import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.set.basis.extensions.PathExtensions;
import org.eclipse.set.basis.files.ToolboxFile;
import org.eclipse.set.core.services.enumtranslation.EnumTranslationService;
import org.eclipse.set.feature.plazmodel.Messages;
import org.eclipse.set.feature.plazmodel.table.PlazModelTableTransformationService;
import org.eclipse.set.model.plazmodel.PlazReport;
import org.eclipse.set.model.tablemodel.Table;
import org.eclipse.set.model.validationreport.ValidationProblem;
import org.eclipse.set.utils.BasePart;
import org.eclipse.set.utils.table.menu.TableMenuService;
import org.eclipse.set.utils.table.tree.AbstractTreeLayerTable;
import org.eclipse.set.utils.xml.XMLNodeFinder;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class PlazModelTableView
extends AbstractTreeLayerTable {
    static final String HEADER_PATTERN = "PlaZ-Modell-Pr\u00fcfung\nDatei: %s\nPr\u00fcfungszeit: %s\nWerkzeugkofferversion: %s\n\n\n\"Lfd. Nr.\";\"Schweregrad\";\"Problemart\";\"Zeilennummer\";\"Objektart\";\"Attribut/-gruppe\";\"Bereich\";\"Zustand\";\"Meldung\"\n";
    private final Messages messages;
    private final BasePart part;
    private final EnumTranslationService enumTranslationService;
    private NatTable natTable;
    private final TableMenuService tableMenuService;
    private final XMLNodeFinder xmlNodeFinder;

    public PlazModelTableView(BasePart part, Messages messages, TableMenuService tableMenuService, EnumTranslationService enumTranslationService) {
        this.part = part;
        this.messages = messages;
        this.tableMenuService = tableMenuService;
        this.enumTranslationService = enumTranslationService;
        ToolboxFile toolboxFile = part.getModelSession().getToolboxFile();
        this.xmlNodeFinder = new XMLNodeFinder();
        this.xmlNodeFinder.read(toolboxFile, toolboxFile.getModelPath());
    }

    public Control create(Composite parent, PlazReport validationReport) {
        PlazModelTableTransformationService service = new PlazModelTableTransformationService(this.messages, this.enumTranslationService);
        Table table = service.transform(validationReport);
        this.createTableBodyData(table, rowIndex -> ((ValidationProblem)validationReport.getEntries().get(rowIndex - 1)).getLineNumber());
        this.tableMenuService.addMenuItem(this.createJumpToTextViewMenuItem(this.part));
        this.tableMenuService.addMenuItem(this.createJumpToSiteplanMenuItem());
        this.natTable = this.createTable(parent, table);
        return this.natTable;
    }

    public void updateView(PlazReport report) {
        if (this.natTable != null) {
            PlazModelTableTransformationService service = new PlazModelTableTransformationService(this.messages, this.enumTranslationService);
            this.bodyDataProvider.refresh(service.transform(report));
            this.natTable.refresh();
        }
    }

    protected TableMenuService getTableMenuService() {
        return this.tableMenuService;
    }

    protected XMLNodeFinder getXMLNodeFinder() {
        return this.xmlNodeFinder;
    }

    protected String getCSVHeaderPattern() {
        return HEADER_PATTERN;
    }

    public void exportCsv() {
        Path location = this.part.getModelSession().getToolboxFile().getPath();
        String defaultFileName = String.format(this.messages.PlazModellPart_ExportCsvFilePattern, PathExtensions.getBaseFileName((Path)location));
        this.exportCsv(this.part.getToolboxShell(), this.part.getDialogService(), this.messages.PlazModellPart_ExportTitleMsg, defaultFileName);
    }
}

