/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.utils.table.menu;

import java.util.Collection;
import java.util.List;
import java.util.function.IntPredicate;
import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.command.ILayerCommand;
import org.eclipse.nebula.widgets.nattable.config.AbstractUiBindingConfiguration;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.cell.ILayerCell;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;
import org.eclipse.nebula.widgets.nattable.selection.command.SelectRowsCommand;
import org.eclipse.nebula.widgets.nattable.ui.NatEventData;
import org.eclipse.nebula.widgets.nattable.ui.action.IMouseAction;
import org.eclipse.nebula.widgets.nattable.ui.binding.UiBindingRegistry;
import org.eclipse.nebula.widgets.nattable.ui.matcher.IMouseEventMatcher;
import org.eclipse.nebula.widgets.nattable.ui.matcher.MouseEventMatcher;
import org.eclipse.nebula.widgets.nattable.ui.menu.IMenuItemProvider;
import org.eclipse.nebula.widgets.nattable.ui.menu.IMenuItemState;
import org.eclipse.nebula.widgets.nattable.ui.menu.PopupMenuAction;
import org.eclipse.nebula.widgets.nattable.ui.menu.PopupMenuBuilder;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

public class TableBodyMenuConfiguration
extends AbstractUiBindingConfiguration {
    protected final Menu bodyMenu;
    private final SelectionLayer selectionLayer;

    public TableBodyMenuConfiguration(NatTable natTable, SelectionLayer selectionLayer, List<TableBodyMenuItem> menuItems) {
        this.selectionLayer = selectionLayer;
        this.bodyMenu = TableBodyMenuConfiguration.createBodyMenu(natTable, menuItems).build();
    }

    protected static PopupMenuBuilder createBodyMenu(NatTable natTable, List<TableBodyMenuItem> menuItems) {
        PopupMenuBuilder popupMenu = new PopupMenuBuilder(natTable);
        menuItems.forEach(item -> {
            PopupMenuBuilder popupMenuBuilder2 = popupMenu.withMenuItemProvider(item.label, (IMenuItemProvider)item).withEnabledState(item.label, (IMenuItemState)item);
        });
        return popupMenu;
    }

    public void configureUiBindings(UiBindingRegistry uiBindingRegistry) {
        uiBindingRegistry.registerMouseDownBinding((IMouseEventMatcher)new MouseEventMatcher(0, "BODY", 3), (IMouseAction)new PopupMenuAction(this.bodyMenu){

            public void run(NatTable natTable, MouseEvent event) {
                natTable.doCommand((ILayerCommand)new SelectRowsCommand((ILayer)natTable, natTable.getColumnPositionByX(event.x), natTable.getRowPositionByY(event.y), (event.stateMask & SWT.MOD2) != 0, (event.stateMask & SWT.MOD1) != 0));
                if (TableBodyMenuConfiguration.this.selectionLayer.getSelectedCells().isEmpty()) {
                    return;
                }
                super.run(natTable, event);
            }
        });
    }

    public record TableBodyMenuItem(String label, SelectionLayer selectionLayer, SelectionListener selectionListener, IntPredicate enablePredicate) implements IMenuItemProvider,
    IMenuItemState
    {
        public void addMenuItem(NatTable natTable, Menu popupMenu) {
            MenuItem menuItem = new MenuItem(popupMenu, 8);
            menuItem.setText(this.label);
            menuItem.addSelectionListener(this.selectionListener);
        }

        public boolean isActive(NatEventData natEventData) {
            Collection selectedCells = this.selectionLayer.getSelectedCells();
            if (selectedCells.isEmpty()) {
                return false;
            }
            return this.enablePredicate.test(((ILayerCell)selectedCells.iterator().next()).getRowPosition());
        }
    }
}

