/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.application.geometry;

import java.lang.runtime.SwitchBootstraps;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.StreamSupport;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.set.basis.Pair;
import org.eclipse.set.basis.constants.ContainerType;
import org.eclipse.set.basis.geometry.GEOKanteCoordinate;
import org.eclipse.set.basis.geometry.GEOKanteMetadata;
import org.eclipse.set.basis.geometry.GEOKanteSegment;
import org.eclipse.set.basis.geometry.GeoPosition;
import org.eclipse.set.basis.geometry.Geometries;
import org.eclipse.set.basis.geometry.GeometryException;
import org.eclipse.set.basis.geometry.SegmentPosition;
import org.eclipse.set.basis.graph.DirectedElement;
import org.eclipse.set.core.services.Services;
import org.eclipse.set.core.services.geometry.GeoKanteGeometryService;
import org.eclipse.set.model.planpro.BasisTypen.ENUMWirkrichtung;
import org.eclipse.set.model.planpro.Basisobjekte.Basis_Objekt;
import org.eclipse.set.model.planpro.Basisobjekte.Bereich_Objekt;
import org.eclipse.set.model.planpro.Basisobjekte.Punkt_Objekt;
import org.eclipse.set.model.planpro.Basisobjekte.Punkt_Objekt_TOP_Kante_AttributeGroup;
import org.eclipse.set.model.planpro.Basisobjekte.Ur_Objekt;
import org.eclipse.set.model.planpro.Geodaten.GEO_Kante;
import org.eclipse.set.model.planpro.Geodaten.GEO_Knoten;
import org.eclipse.set.model.planpro.Geodaten.Strecke;
import org.eclipse.set.model.planpro.Geodaten.Strecke_Punkt;
import org.eclipse.set.model.planpro.Geodaten.TOP_Kante;
import org.eclipse.set.model.planpro.Geodaten.TOP_Knoten;
import org.eclipse.set.model.planpro.PlanPro.PlanPro_Schnittstelle;
import org.eclipse.set.ppmodel.extensions.BasisAttributExtensions;
import org.eclipse.set.ppmodel.extensions.EObjectExtensions;
import org.eclipse.set.ppmodel.extensions.GeoKanteExtensions;
import org.eclipse.set.ppmodel.extensions.GeoKnotenExtensions;
import org.eclipse.set.ppmodel.extensions.PlanProSchnittstelleExtensions;
import org.eclipse.set.ppmodel.extensions.PunktObjektTopKanteExtensions;
import org.eclipse.set.ppmodel.extensions.StreckeExtensions;
import org.eclipse.set.ppmodel.extensions.TopKanteExtensions;
import org.eclipse.set.ppmodel.extensions.TopKnotenExtensions;
import org.eclipse.set.ppmodel.extensions.container.MultiContainer_AttributeGroup;
import org.eclipse.set.ppmodel.extensions.geometry.GEOKanteGeometryExtensions;
import org.eclipse.set.ppmodel.extensions.utils.CacheUtils;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineSegment;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.operation.distance.DistanceOp;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;
import org.osgi.service.event.EventHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(property={"event.topics=modelsession/change/topmodel", "event.topics=modelsession/close"}, service={GeoKanteGeometryService.class, EventHandler.class})
public class GeoKanteGeometryServiceImpl
implements GeoKanteGeometryService,
EventHandler {
    private Thread findGeometryThread;
    static double GEO_LENGTH_DEVIATION_TOLERANCE = 0.001;
    static double GEO_LENGTH_DEVIATION_TOLERANCE_RELATIVE = 1.0E-4;
    static final Logger logger = LoggerFactory.getLogger(GeoKanteGeometryServiceImpl.class);
    private Map<GEO_Kante, LineString> edgeGeometry;
    private Map<String, List<GEOKanteMetadata>> geoKanteMetadas;
    private boolean isProcessComplete = false;
    @Reference
    private EventAdmin eventAdmin;

    public GeoKanteGeometryServiceImpl() {
        Services.setGeometryService((GeoKanteGeometryService)this);
    }

    /*
     * WARNING - void declaration
     */
    public void handleEvent(Event event) {
        Object object;
        String topic = event.getTopic();
        if (topic.equals("modelsession/change/topmodel") && (object = event.getProperty("org.eclipse.e4.data")) instanceof PlanPro_Schnittstelle) {
            void schnitstelle;
            PlanPro_Schnittstelle planPro_Schnittstelle = (PlanPro_Schnittstelle)object;
            PlanPro_Schnittstelle cfr_ignored_0 = (PlanPro_Schnittstelle)object;
            this.edgeGeometry = new ConcurrentHashMap<GEO_Kante, LineString>();
            this.geoKanteMetadas = new ConcurrentHashMap<String, List<GEOKanteMetadata>>();
            this.findGeometryThread = new Thread(() -> this.lambda$0((PlanPro_Schnittstelle)schnitstelle), "toolbox.cache.geokante-geometry");
            this.findGeometryThread.start();
        }
        if (topic.equals("modelsession/close") && this.findGeometryThread != null && this.findGeometryThread.isAlive() && !this.findGeometryThread.isInterrupted()) {
            this.findGeometryThread.interrupt();
            this.isProcessComplete = false;
            this.edgeGeometry.clear();
            this.geoKanteMetadas.clear();
        }
    }

    private void findGeoKanteGeometry(MultiContainer_AttributeGroup container) throws InterruptedException {
        if (container == null) {
            return;
        }
        for (GEO_Kante edge : container.getGEOKante()) {
            if (Thread.currentThread().isInterrupted()) {
                throw new InterruptedException();
            }
            try {
                LineString geometry = GEOKanteGeometryExtensions.defineEdgeGeometry((GEO_Kante)edge);
                if (geometry == null) continue;
                this.edgeGeometry.put(edge, geometry);
            }
            catch (NullPointerException | GeometryException e) {
                logger.warn("Cannot determine geometry for edge {}.", (Object)edge.getIdentitaet().getWert());
            }
        }
    }

    public LineString getGeometry(GEO_Kante edge) {
        while (!this.isFindGeometryComplete()) {
            try {
                Thread.sleep(4000L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return null;
            }
        }
        return this.edgeGeometry.getOrDefault(edge, null);
    }

    public LineString getGeometry(DirectedElement<GEO_Kante> directedEdge) {
        LineString geometry = this.getGeometry((GEO_Kante)directedEdge.getElement());
        if (geometry == null) {
            return null;
        }
        return directedEdge.isForwards() ? geometry : geometry.reverse();
    }

    public boolean isFindGeometryComplete() {
        return this.isProcessComplete;
    }

    public GEOKanteCoordinate getCoordinateAt(Punkt_Objekt punktObjekt, BigDecimal distance) {
        Punkt_Objekt_TOP_Kante_AttributeGroup singlePoint = (Punkt_Objekt_TOP_Kante_AttributeGroup)punktObjekt.getPunktObjektTOPKante().getFirst();
        return this.getCoordinateAt(singlePoint, distance);
    }

    private GEOKanteCoordinate getCoordinateAt(Punkt_Objekt_TOP_Kante_AttributeGroup singlePoint, BigDecimal distance) {
        if (singlePoint == null || singlePoint.getAbstand() == null || singlePoint.getAbstand().getWert() == null) {
            return null;
        }
        BigDecimal pointDistance = singlePoint.getAbstand().getWert().add(distance);
        ENUMWirkrichtung direction = EObjectExtensions.getNullableObject((Object)singlePoint, p -> p.getWirkrichtung().getWert()).orElse(null);
        TOP_Kante topKante = PunktObjektTopKanteExtensions.getTopKante((Punkt_Objekt_TOP_Kante_AttributeGroup)singlePoint);
        if (topKante == null) {
            return null;
        }
        TOP_Knoten start = TopKanteExtensions.getTOPKnotenA((TOP_Kante)topKante);
        GEOKanteMetadata geoEdgeMd = this.getGeoKanteAt(topKante, start, pointDistance);
        if (geoEdgeMd == null) {
            logger.error("Can't found Geo_Kante by TOP_Knoten: {} of TOP_Kante: {}", (Object)start.getIdentitaet().getWert(), (Object)topKante.getIdentitaet().getWert());
            return null;
        }
        BigDecimal lateralDistance = BigDecimal.ZERO;
        if (singlePoint.getSeitlicherAbstand() != null && singlePoint.getSeitlicherAbstand().getWert() != null) {
            lateralDistance = singlePoint.getSeitlicherAbstand().getWert();
        }
        if (direction == ENUMWirkrichtung.ENUM_WIRKRICHTUNG_BEIDE || direction == null) {
            return this.getCoordinate(geoEdgeMd, pointDistance, lateralDistance, ENUMWirkrichtung.ENUM_WIRKRICHTUNG_IN);
        }
        return this.getCoordinate(geoEdgeMd, pointDistance, lateralDistance, direction);
    }

    public GEOKanteCoordinate getCoordinate(TOP_Kante topKante, TOP_Knoten start, BigDecimal distance, BigDecimal lateralDistance, ENUMWirkrichtung wirkrichtung) {
        GEOKanteMetadata md = this.getGeoKanteAt(topKante, start, distance);
        return this.getCoordinate(md, distance, lateralDistance, wirkrichtung);
    }

    public GEOKanteCoordinate getCoordinate(GEOKanteMetadata md, BigDecimal distance, BigDecimal lateralDistance, ENUMWirkrichtung wirkrichtung) {
        GEOKanteSegment segment = md.getContainingSegment(distance);
        if (segment == null) {
            throw new RuntimeException("Missing GEO_Kante segment");
        }
        BigDecimal edgeLength = md.getLength().abs();
        BigDecimal geoLength = BigDecimal.valueOf(md.getGeometry().getLength());
        BigDecimal localDistance = distance.subtract(md.getStart());
        BigDecimal scaledDistance = localDistance.doubleValue() != 0.0 ? localDistance.multiply(geoLength.divide(edgeLength, 5, RoundingMode.HALF_UP)) : BigDecimal.ZERO;
        SegmentPosition position = Geometries.getSegmentPosition((LineString)md.getGeometry(), (Coordinate)GeoKnotenExtensions.getCoordinate((GEO_Knoten)md.getGeoKnoten()), (BigDecimal)scaledDistance);
        LineSegment tangent = GeoKanteExtensions.getTangent((GEO_Kante)md.getGeoKante(), (SegmentPosition)position);
        GeoPosition coordinate = GeoKanteExtensions.getCoordinate((LineSegment)tangent, (SegmentPosition)position, (BigDecimal)lateralDistance, (ENUMWirkrichtung)wirkrichtung);
        return new GEOKanteCoordinate(coordinate, md, GeoKnotenExtensions.getCRS((GEO_Knoten)md.getGeoKnoten()));
    }

    public GEOKanteMetadata getGeoKanteAt(TOP_Kante topKante, TOP_Knoten topKnoten, BigDecimal distance) {
        List<GEOKanteMetadata> geoMetadatas = this.getGeoKanteMetadatas(topKante, topKnoten);
        Optional<GEOKanteMetadata> result = geoMetadatas.stream().filter(md -> md.getStart().compareTo(distance) <= 0 && md.getEnd().compareTo(distance) >= 0).findFirst();
        return result.orElse(null);
    }

    public List<GEOKanteMetadata> getTopKantenMetaData(TOP_Kante topKante) {
        return this.getGeoKanteMetadatas(topKante, topKante.getIDTOPKnotenA().getValue());
    }

    public List<GEOKanteMetadata> getStreckeMetaData(Strecke strecke) {
        String key = CacheUtils.getCacheKey((Object)strecke);
        return this.geoKanteMetadas.computeIfAbsent(key, k -> {
            try {
                Strecke_Punkt[] startEnd = StreckeExtensions.getStartEnd((Strecke)strecke);
                return this.getGeoKantenMetadata((Basis_Objekt)strecke, startEnd[0].getIDGEOKnoten().getValue(), Collections.emptyList());
            }
            catch (Exception e) {
                return null;
            }
        });
    }

    public GEOKanteMetadata getGeoKanteMetaData(GEO_Kante geoKante) {
        Basis_Objekt geoArt;
        Basis_Objekt basis_Objekt = geoArt = geoKante.getIDGEOArt().getValue();
        Objects.requireNonNull(basis_Objekt);
        Basis_Objekt basis_Objekt2 = basis_Objekt;
        int n = 0;
        List<GEOKanteMetadata> metaDatas = switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{TOP_Kante.class, Strecke.class}, (Object)basis_Objekt2, n)) {
            case 0 -> {
                TOP_Kante topKante = (TOP_Kante)basis_Objekt2;
                yield this.getTopKantenMetaData(topKante);
            }
            case 1 -> {
                Strecke strecke = (Strecke)basis_Objekt2;
                yield this.getStreckeMetaData(strecke);
            }
            default -> throw new IllegalArgumentException();
        };
        return metaDatas.stream().filter(md -> md.getGeoKante() == geoKante).findFirst().orElse(null);
    }

    private List<GEOKanteMetadata> getGeoKanteMetadatas(TOP_Kante topEdge, TOP_Knoten start) {
        String key = CacheUtils.getCacheKey((Ur_Objekt)topEdge, (Object)start);
        return this.geoKanteMetadas.computeIfAbsent(key, k -> {
            List<Bereich_Objekt> bereichObjekt = StreamSupport.stream(BasisAttributExtensions.getContainer((EObject)start).getBereichObjekt().spliterator(), false).toList();
            return this.getGeoKantenMetadata((Basis_Objekt)topEdge, TopKnotenExtensions.getGEOKnoten((TOP_Knoten)start), bereichObjekt);
        });
    }

    public Pair<GEOKanteCoordinate, BigDecimal> getProjectionCoordinateOnTopKante(Coordinate coor, TOP_Kante topEdge) {
        return this.getProjectionCoordinate(coor, (Basis_Objekt)topEdge);
    }

    private Pair<GEOKanteCoordinate, BigDecimal> getProjectionCoordinate(Coordinate coordinate, Basis_Objekt object) {
        try {
            Pair<GEOKanteMetadata, Coordinate> projectionCoorAndGeoKante = this.getClosestProjection(coordinate, object);
            if (projectionCoorAndGeoKante == null) {
                throw new NullPointerException();
            }
            GEOKanteMetadata metadata = (GEOKanteMetadata)projectionCoorAndGeoKante.getFirst();
            Coordinate projectionCoor = (Coordinate)projectionCoorAndGeoKante.getSecond();
            BigDecimal projectionDistance = GeoKanteGeometryServiceImpl.getCoordinateTopDistance(metadata, projectionCoor);
            GEOKanteSegment relevantSegments = metadata.getSegments().stream().filter(segment -> projectionDistance.compareTo(segment.getStart()) >= 0 && projectionDistance.compareTo(segment.getEnd()) <= 0).findFirst().orElse(null);
            if (relevantSegments == null) {
                throw new IllegalArgumentException();
            }
            return new Pair((Object)new GEOKanteCoordinate(projectionCoor, metadata, GeoKnotenExtensions.getCRS((GEO_Knoten)metadata.getGeoKnoten())), (Object)projectionDistance);
        }
        catch (IllegalArgumentException | NullPointerException e) {
            logger.error("Can't find projection of Coordinate: ({}, {}) on {} {}", new Object[]{coordinate.x, coordinate.y, object.getClass().getName(), object.getIdentitaet().getWert()});
            return null;
        }
    }

    private static BigDecimal getCoordinateTopDistance(GEOKanteMetadata metadata, Coordinate coordinate) throws IllegalArgumentException {
        Coordinate currentCoordinate;
        BigDecimal distance = metadata.getStart();
        Coordinate previousCoordinate = null;
        ArrayDeque<Coordinate> geoCoordinates = new ArrayDeque<Coordinate>();
        geoCoordinates.addAll(Arrays.asList(metadata.getGeometry().getCoordinates()));
        while ((currentCoordinate = (Coordinate)geoCoordinates.poll()) != null) {
            if (previousCoordinate == null) {
                previousCoordinate = currentCoordinate;
                continue;
            }
            double distanceToCurrentCoord = previousCoordinate.distance(currentCoordinate);
            double distanceToTargetCoord = previousCoordinate.distance(coordinate);
            boolean isOnLine = GEOKanteCoordinate.isOnLine((Coordinate)coordinate, (Coordinate)previousCoordinate, (Coordinate)currentCoordinate, (double)GEO_LENGTH_DEVIATION_TOLERANCE_RELATIVE);
            if (isOnLine && distanceToCurrentCoord >= distanceToTargetCoord) {
                return distance.add(BigDecimal.valueOf(distanceToTargetCoord).round(new MathContext(5)));
            }
            distance = distance.add(BigDecimal.valueOf(distanceToCurrentCoord));
            previousCoordinate = currentCoordinate;
        }
        throw new IllegalArgumentException(String.format("The coordinate (%f, %f) not lie on the TOP_Kante: %s", coordinate.x, coordinate.y, metadata.getGeoKante().getIDGEOArt().getWert()));
    }

    public Pair<GEOKanteCoordinate, BigDecimal> getProjectionCoordinateOnStrecke(Coordinate coordinate, Strecke strecke) {
        return this.getProjectionCoordinate(coordinate, (Basis_Objekt)strecke);
    }

    private Pair<GEOKanteMetadata, Coordinate> getClosestProjection(Coordinate coordinate, Basis_Objekt geoArt) {
        GeometryFactory geometryFactory = new GeometryFactory();
        Basis_Objekt basis_Objekt = geoArt;
        Objects.requireNonNull(basis_Objekt);
        Basis_Objekt basis_Objekt2 = basis_Objekt;
        int n = 0;
        List<GEOKanteMetadata> metadatas = switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{TOP_Kante.class, Strecke.class}, (Object)basis_Objekt2, n)) {
            case 0 -> {
                TOP_Kante topKante = (TOP_Kante)basis_Objekt2;
                yield this.getTopKantenMetaData(topKante);
            }
            case 1 -> {
                Strecke strecke = (Strecke)basis_Objekt2;
                yield this.getStreckeMetaData(strecke);
            }
            default -> throw new IllegalArgumentException();
        };
        Pair metaDataWithDistance = metadatas.stream().map(geoKante -> {
            LineString geometry = geoKante.getGeometry();
            DistanceOp distanceOp = new DistanceOp((Geometry)geometry, (Geometry)geometryFactory.createPoint(coordinate));
            return new Pair(geoKante, (Object)distanceOp);
        }).min((fisrt, second) -> {
            double firstDistance = ((DistanceOp)fisrt.getSecond()).distance();
            double seconDistance = ((DistanceOp)second.getSecond()).distance();
            return Double.compare(firstDistance, seconDistance);
        }).orElse(null);
        if (metaDataWithDistance == null) {
            return null;
        }
        Coordinate[] nearestPoints = ((DistanceOp)metaDataWithDistance.getSecond()).nearestPoints();
        if (nearestPoints.length == 0) {
            return null;
        }
        return new Pair((Object)((GEOKanteMetadata)metaDataWithDistance.getFirst()), (Object)nearestPoints[0]);
    }

    private List<GEOKanteMetadata> getGeoKantenMetadata(Basis_Objekt geoArt, GEO_Knoten startKnoten, List<Bereich_Objekt> bereichObjekte) {
        BigDecimal distanceScalingFactor = GeoKanteGeometryServiceImpl.getScalingFactor(geoArt);
        BigDecimal distance = BigDecimal.ZERO;
        GEO_Knoten geoKnoten = startKnoten;
        GEO_Kante geoKante = null;
        ArrayList<GEOKanteMetadata> geoKanteMetadata = new ArrayList<GEOKanteMetadata>();
        while (true) {
            Basis_Objekt basis_Objekt;
            List geoKanten = GeoKnotenExtensions.getGeoKantenOnParentKante((GEO_Knoten)geoKnoten, (Basis_Objekt)geoArt);
            geoKanten.remove(geoKante);
            if (geoKanten.isEmpty()) {
                return geoKanteMetadata;
            }
            geoKante = (GEO_Kante)geoKanten.get(0);
            BigDecimal geoKanteLength = geoKante.getGEOKanteAllg().getGEOLaenge().getWert().multiply(BigDecimal.ONE.divide(distanceScalingFactor, 5, RoundingMode.HALF_UP));
            LineString geometry = this.getGeometry(geoKante);
            Objects.requireNonNull(geoArt);
            int n = 0;
            GEOKanteMetadata metadata = switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{TOP_Kante.class, Strecke.class}, (Object)basis_Objekt, n)) {
                case 0 -> {
                    TOP_Kante topKante = (TOP_Kante)basis_Objekt;
                    yield new GEOKanteMetadata(geoKante, distance, geoKanteLength, bereichObjekte, topKante, geoKnoten, geometry);
                }
                case 1 -> {
                    Strecke streck = (Strecke)basis_Objekt;
                    yield new GEOKanteMetadata(geoKante, distance, geoKnoten, geometry);
                }
                default -> throw new IllegalArgumentException("Unexpected value: " + String.valueOf(geoArt));
            };
            geoKanteMetadata.add(metadata);
            distance = distance.add(geoKanteLength);
            geoKnoten = GeoKanteExtensions.getOpposite((GEO_Kante)geoKante, (GEO_Knoten)geoKnoten);
        }
    }

    private static BigDecimal getScalingFactor(Basis_Objekt geoArt) throws IllegalArgumentException {
        BigDecimal tolerance;
        List<GEO_Kante> geoKantenOnGeoArt = GeoKanteGeometryServiceImpl.getGeoKanten(geoArt);
        BigDecimal geoLength = BigDecimal.ZERO;
        for (GEO_Kante geoKante : geoKantenOnGeoArt) {
            try {
                geoLength = geoLength.add(geoKante.getGEOKanteAllg().getGEOLaenge().getWert());
            }
            catch (NullPointerException e) {
                logger.error("Geo_Kante: {} missing Geo_Laenge", (Object)geoKante.getIdentitaet().getWert());
            }
        }
        BigDecimal geoArtLength = GeoKanteGeometryServiceImpl.getGeoArtLength(geoArt);
        BigDecimal difference = geoLength.subtract(geoArtLength).abs();
        if (difference.compareTo(tolerance = BigDecimal.valueOf(GEO_LENGTH_DEVIATION_TOLERANCE).max(geoArtLength.multiply(BigDecimal.valueOf(GEO_LENGTH_DEVIATION_TOLERANCE_RELATIVE)))) > 0) {
            logger.debug("lengthGeoArt={}", (Object)geoArtLength);
            logger.debug("lengthGeoKanten={}", (Object)geoLength);
            logger.debug("geoKantenOnGeoArt={}", (Object)geoKantenOnGeoArt.size());
            logger.warn("Difference of GEO Kanten length and GeoArt length for GeoArt {} greater than tolerance {} ({}).", new Object[]{geoArt.getIdentitaet().getWert(), tolerance, difference});
        }
        if (geoLength.compareTo(BigDecimal.ZERO) <= 0 || geoArtLength.compareTo(BigDecimal.ZERO) <= 0) {
            return BigDecimal.ONE;
        }
        BigDecimal scale = geoLength.divide(geoArtLength, 5, RoundingMode.HALF_UP);
        return scale.compareTo(BigDecimal.ZERO) > 0 ? scale : BigDecimal.ONE;
    }

    private static List<GEO_Kante> getGeoKanten(Basis_Objekt geoArt) {
        Basis_Objekt basis_Objekt = geoArt;
        Objects.requireNonNull(basis_Objekt);
        Basis_Objekt basis_Objekt2 = basis_Objekt;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{TOP_Kante.class, Strecke.class}, (Object)basis_Objekt2, n)) {
            case 0 -> {
                TOP_Kante topKante = (TOP_Kante)basis_Objekt2;
                yield TopKanteExtensions.getGeoKanten((TOP_Kante)topKante);
            }
            case 1 -> {
                Strecke strecke = (Strecke)basis_Objekt2;
                yield StreckeExtensions.getGeoKanten((Strecke)strecke);
            }
            default -> throw new IllegalArgumentException("Unexpected value: " + String.valueOf(geoArt));
        };
    }

    private static BigDecimal getGeoArtLength(Basis_Objekt geoArt) {
        Basis_Objekt basis_Objekt = geoArt;
        Objects.requireNonNull(basis_Objekt);
        Basis_Objekt basis_Objekt2 = basis_Objekt;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{TOP_Kante.class, Strecke.class}, (Object)basis_Objekt2, n)) {
            case 0 -> {
                TOP_Kante topKante = (TOP_Kante)basis_Objekt2;
                yield topKante.getTOPKanteAllg().getTOPLaenge().getWert();
            }
            case 1 -> {
                Strecke strecke = (Strecke)basis_Objekt2;
                yield StreckeExtensions.getStreckeLength((Strecke)strecke);
            }
            default -> throw new IllegalArgumentException("Unexpected value: " + String.valueOf(geoArt));
        };
    }

    private /* synthetic */ void lambda$0(PlanPro_Schnittstelle planPro_Schnittstelle) {
        try {
            logger.debug("Start find geometry of GEO_Kante");
            this.isProcessComplete = false;
            this.findGeoKanteGeometry(PlanProSchnittstelleExtensions.getContainer((PlanPro_Schnittstelle)planPro_Schnittstelle, (ContainerType)ContainerType.INITIAL));
            this.findGeoKanteGeometry(PlanProSchnittstelleExtensions.getContainer((PlanPro_Schnittstelle)planPro_Schnittstelle, (ContainerType)ContainerType.FINAL));
            this.findGeoKanteGeometry(PlanProSchnittstelleExtensions.getContainer((PlanPro_Schnittstelle)planPro_Schnittstelle, (ContainerType)ContainerType.SINGLE));
            this.isProcessComplete = true;
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.put("event.topics", "geometryService/done");
            this.eventAdmin.sendEvent(new Event("geometryService/done", properties));
            logger.debug("Find geometry of GEO_Kante process is complete");
        }
        catch (InterruptedException e) {
            this.isProcessComplete = true;
            Thread.currentThread().interrupt();
        }
    }
}

