/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.feature.export.parts;

import jakarta.inject.Inject;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.function.Consumer;
import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.set.basis.OverwriteHandling;
import org.eclipse.set.basis.guid.Guid;
import org.eclipse.set.model.planpro.PlanPro.PlanPro_Schnittstelle;
import org.eclipse.set.model.titlebox.Titlebox;
import org.eclipse.set.ppmodel.extensions.utils.PlanProToTitleboxTransformation;
import org.eclipse.set.services.export.ExportService;
import org.eclipse.set.utils.BasePart;
import org.eclipse.set.utils.exception.ExceptionHandler;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class TitleBoxImagePart
extends BasePart {
    private static final String TITLEBOX_IMAGE = "titlebox.png";
    @Inject
    private ExportService exportService;

    private static Image createImage(String image, LocalResourceManager localResourceManager) {
        ImageDescriptor titleboxDescriptor = ImageDescriptor.createFromFile(null, (String)image);
        return (Image)localResourceManager.create((DeviceResourceDescriptor)titleboxDescriptor);
    }

    private static void createTitlebox(Composite parent) {
        parent.setLayout((Layout)new GridLayout(1, true));
        Label label = new Label(parent, 0);
        LocalResourceManager localResourceManager = new LocalResourceManager(JFaceResources.getResources(), (Control)label);
        label.setImage(TitleBoxImagePart.createImage(TITLEBOX_IMAGE, localResourceManager));
    }

    @Inject
    public TitleBoxImagePart() {
    }

    private Path getAttachmentPath(String guid) {
        try {
            return this.getModelSession().getToolboxFile().getMediaPath(Guid.create((String)guid));
        }
        catch (UnsupportedOperationException e) {
            return null;
        }
    }

    private void createTitleboxImage(PlanPro_Schnittstelle planProSchnittstelle) throws Exception {
        PlanProToTitleboxTransformation planProToTitlebox = PlanProToTitleboxTransformation.create();
        Titlebox titlebox = planProToTitlebox.transform(planProSchnittstelle, null, this::getAttachmentPath);
        this.exportService.exportTitleboxImage(titlebox, Paths.get(this.getModelSession().getTempDir().toString(), TITLEBOX_IMAGE), OverwriteHandling.forCheckbox((boolean)true), (Consumer)new ExceptionHandler(this.getToolboxShell(), this.getDialogService()));
    }

    protected void createView(Composite parent) {
        if (this.getModelSession() != null) {
            try {
                this.createTitleboxImage(this.getModelSession().getPlanProSchnittstelle());
                TitleBoxImagePart.createTitlebox(parent);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

