/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.utils.events;

import java.util.Collections;
import java.util.Set;
import org.eclipse.set.basis.constants.TableType;
import org.eclipse.set.utils.events.ToolboxEvent;

public class SelectedControlAreaChangedEvent
implements ToolboxEvent {
    private static final String TOPIC = "toolboxevents/controlarea/selection";
    Set<ControlAreaValue> areas;
    private final TableType tableType;
    private final boolean isPlanningAreaIgnored;

    public TableType getTableType() {
        return this.tableType;
    }

    public SelectedControlAreaChangedEvent() {
        this.areas = null;
        this.tableType = null;
        this.isPlanningAreaIgnored = false;
    }

    public SelectedControlAreaChangedEvent(TableType tableType, boolean isPlanningAreaIgnored) {
        this(Collections.emptySet(), tableType, isPlanningAreaIgnored);
    }

    public SelectedControlAreaChangedEvent(ControlAreaValue area, TableType tableType, boolean isPlanningAreaIgnored) {
        this(Set.of(area), tableType, isPlanningAreaIgnored);
    }

    public SelectedControlAreaChangedEvent(Set<ControlAreaValue> areas, TableType tableType, boolean isPlanningAreaIgnored) {
        this.areas = areas;
        this.tableType = tableType;
        this.isPlanningAreaIgnored = isPlanningAreaIgnored;
    }

    public Set<ControlAreaValue> getControlAreas() {
        return this.areas;
    }

    public boolean isPlanningAreaIgnored() {
        return this.isPlanningAreaIgnored;
    }

    @Override
    public String getTopic() {
        return TOPIC;
    }

    public record ControlAreaValue(String areaName, String areaId) {
    }
}

