/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.utils;

import java.util.Comparator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

public class StringExtensions {
    private static final Pattern ENV_PATTERN = Pattern.compile("(?<start>[^$]*)\\$(?<var>[^$]+)\\$(?<end>.*)");
    private static final String ENV_VAR = "var";
    private static final int CHARACTER_PRO_CM = 6;
    private static final String ZERO_WIDTH_SPACE = "\u200b";

    public static String intersperseWithZeroSpaces(String string) {
        return string.replaceAll("(.)", "$1\u200b");
    }

    public static String intersperseWithZeroSpacesSC(String string) {
        return string.replaceAll("([ /\\-_)}\\]])", "$1\u200b");
    }

    public static String intersperseWithZeroSpacesLength(String string, int maxChar) {
        boolean _lessThan;
        int _length = string.length();
        boolean bl = _lessThan = _length < maxChar;
        if (_lessThan) {
            return string;
        }
        Functions.Function1 _function = it -> {
            boolean _lessThan_1;
            int _length_1 = it.length();
            boolean bl = _lessThan_1 = _length_1 < maxChar;
            if (_lessThan_1) {
                return it;
            }
            StringBuilder sb = new StringBuilder((String)it);
            CharSequence head = sb.subSequence(0, maxChar);
            String tail = sb.substring(maxChar);
            String newTail = StringExtensions.intersperseWithZeroSpacesLength(tail, maxChar);
            String _plus = String.valueOf(head) + ZERO_WIDTH_SPACE;
            return _plus + newTail;
        };
        List result = ListExtensions.map((List)((List)Conversions.doWrapArray((Object)string.split(" "))), (Functions.Function1)_function);
        return IterableExtensions.join((Iterable)result, (CharSequence)" ");
    }

    public static int maxCharInCell(float cellWidth) {
        return Math.round(cellWidth * 6.0f);
    }

    public static String toPaddedString(String string, int columnWidth) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("%");
        _builder.append((Object)columnWidth);
        _builder.append("s");
        return String.format(_builder.toString(), string);
    }

    public static String shortenBy(String string, int numberOfCharacters) {
        int length = string.length();
        if (length > numberOfCharacters) {
            return string.substring(0, length - numberOfCharacters);
        }
        return "";
    }

    public static String removeSuffix(String string, String ... suffix) {
        Comparator _function = (a, b) -> Integer.compare(b.length(), a.length());
        List sortedSuffix = IterableExtensions.sortWith((Iterable)((Iterable)Conversions.doWrapArray((Object)suffix)), (Comparator)_function);
        for (String p : sortedSuffix) {
            boolean _endsWith = string.endsWith(p);
            if (!_endsWith) continue;
            int _length = string.length();
            int _length_1 = p.length();
            int _minus = _length - _length_1;
            return string.substring(0, _minus);
        }
        return string;
    }

    public static boolean nullSafeEquals(String string, String other) {
        if (string == null || other == null) {
            return string == other;
        }
        return string.equals(other);
    }

    public static String expandFromEnvironment(String string) {
        String result = String.valueOf(string);
        Matcher matcher = ENV_PATTERN.matcher(result);
        while (matcher.matches()) {
            String name = matcher.group(ENV_VAR);
            String expanded = System.getenv(name);
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("$");
            _builder.append(name);
            _builder.append("$");
            result = string.replace((CharSequence)_builder, expanded);
            matcher = ENV_PATTERN.matcher(result);
        }
        return result;
    }
}

