/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.rap.rwt.internal.lifecycle.WidgetLCA;
import org.eclipse.rap.rwt.internal.textsize.TextSizeUtil;
import org.eclipse.rap.rwt.internal.theme.ThemeAdapter;
import org.eclipse.rap.rwt.theme.BoxDimensions;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.widgets.MarkupUtil;
import org.eclipse.swt.internal.widgets.MarkupValidator;
import org.eclipse.swt.internal.widgets.expandbarkit.ExpandBarThemeAdapter;
import org.eclipse.swt.internal.widgets.expanditemkit.ExpandItemLCA;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.ExpandBar;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Widget;

public class ExpandItem
extends Item {
    static final int LEFT_MARGIN = 4;
    static final int RIGHT_MARGIN = 24;
    static final int INTERNAL_SPACING = 4;
    static final int CHEVRON_SIZE = 24;
    ExpandBar parent;
    Control control;
    boolean expanded;
    int x;
    int y;
    int width;
    int height;
    int imageHeight;
    int imageWidth;

    public ExpandItem(ExpandBar parent, int style) {
        this(parent, style, ExpandItem.checkNull(parent).getItemCount());
    }

    public ExpandItem(ExpandBar parent, int style, int index) {
        super(parent, style);
        this.parent = parent;
        parent.createItem(this, index);
    }

    static ExpandBar checkNull(ExpandBar control) {
        if (control == null) {
            SWT.error(4);
        }
        return control;
    }

    @Override
    public void dispose() {
        if (!this.isDisposed()) {
            this.parent.destroyItem(this);
            if (this.control != null) {
                this.control.dispose();
                this.control = null;
            }
            super.dispose();
        }
    }

    public Control getControl() {
        this.checkWidget();
        return this.control;
    }

    public boolean getExpanded() {
        this.checkWidget();
        return this.expanded;
    }

    public int getHeaderHeight() {
        this.checkWidget();
        Font font = this.parent.getFont();
        BoxDimensions itemHeaderBorder = this.getItemHeaderBorder();
        int borderHeight = itemHeaderBorder.top + itemHeaderBorder.bottom;
        int textHeight = TextSizeUtil.textExtent((Font)font, (String)this.text, (int)-1, (boolean)MarkupUtil.isMarkupEnabledFor((Widget)this.parent)).y + 4;
        return Math.max(Math.max(24, this.imageHeight), textHeight) + borderHeight;
    }

    public int getHeight() {
        this.checkWidget();
        return this.height;
    }

    public ExpandBar getParent() {
        this.checkWidget();
        return this.parent;
    }

    int getPreferredWidth() {
        if (!this.isDisposed()) {
            int width;
            Image image = this.getImage();
            String text = this.getText();
            int n = width = image == null ? 0 : image.getBounds().width;
            if (width > 0) {
                width += 4;
            }
            return (width += TextSizeUtil.textExtent((Font)this.parent.getFont(), (String)text, (int)-1, (boolean)MarkupUtil.isMarkupEnabledFor((Widget)this.parent)).x) + 4 + 24;
        }
        return 0;
    }

    Rectangle getBounds() {
        BoxDimensions itemBorder = this.getItemBorder();
        int itemHeight = this.getHeaderHeight() + itemBorder.top + itemBorder.bottom;
        if (this.expanded) {
            itemHeight += this.height;
        }
        return new Rectangle(this.x, this.y, this.width, itemHeight);
    }

    void setBounds(int x, int y, int width, int height, boolean move, boolean size) {
        int headerHeight = this.getHeaderHeight();
        int aX = x;
        int aY = y;
        int aWidth = width;
        int aHeight = height;
        if (move) {
            if (this.imageHeight > headerHeight) {
                aY += this.imageHeight - headerHeight;
            }
            this.x = aX;
            this.y = aY;
        }
        if (size) {
            this.width = aWidth;
            this.height = aHeight;
        }
        if (this.control != null && !this.control.isDisposed()) {
            if (!this.parent.isAppThemed()) {
                BoxDimensions border = this.getItemBorder();
                aX += border.left;
                aY += border.top;
                aWidth = Math.max(0, aWidth - border.left - border.right);
                aHeight = Math.max(0, aHeight - border.top - border.bottom);
            }
            if (move && size) {
                this.control.setBounds(aX, aY + headerHeight, aWidth, aHeight);
            }
            if (move && !size) {
                this.control.setLocation(aX, aY + headerHeight);
            }
            if (!move && size) {
                this.control.setSize(aWidth, aHeight);
            }
        }
    }

    public void setControl(Control control) {
        this.checkWidget();
        if (control != null) {
            if (control.isDisposed()) {
                this.error(5);
            }
            if (control._getParent() != this.parent) {
                this.error(32);
            }
        }
        this.control = control;
        if (control != null) {
            int headerHeight = this.getHeaderHeight();
            control.setVisible(this.expanded);
            if (!this.parent.isAppThemed()) {
                BoxDimensions border = this.getItemBorder();
                int width = Math.max(0, this.width - border.left - border.right);
                int height = Math.max(0, this.height - border.top - border.bottom);
                control.setBounds(this.x + border.left, this.y + border.top + headerHeight, width, height);
            } else {
                control.setBounds(this.x, this.y + headerHeight, this.width, this.height);
            }
        }
    }

    public void setExpanded(boolean expanded) {
        this.checkWidget();
        this.expanded = expanded;
        this.parent.showItem(this);
    }

    public void setHeight(int height) {
        this.checkWidget();
        if (height >= 0) {
            this.setBounds(0, 0, this.width, height, false, true);
            if (this.expanded) {
                this.parent.layoutItems(this.parent.indexOf(this) + 1);
            }
        }
    }

    @Override
    public void setImage(Image image) {
        this.checkWidget();
        if (image != this.getImage()) {
            super.setImage(image);
            this.updateBounds();
        }
        int oldImageHeight = this.imageHeight;
        if (image != null) {
            Rectangle bounds = image.getBounds();
            this.imageHeight = bounds.height;
            this.imageWidth = bounds.width;
        } else {
            this.imageWidth = 0;
            this.imageHeight = 0;
        }
        if (oldImageHeight != this.imageHeight) {
            this.parent.layoutItems(this.parent.indexOf(this));
        }
    }

    @Override
    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            SWT.error(4);
        }
        if (MarkupUtil.isMarkupEnabledFor(this.parent) && !MarkupValidator.isValidationDisabledFor(this.parent)) {
            MarkupValidator.getInstance().validate(string);
        }
        if (!string.equals(this.getText())) {
            super.setText(string);
            this.updateBounds();
        }
    }

    @Override
    public <T> T getAdapter(Class<T> adapter) {
        if (adapter == WidgetLCA.class) {
            return (T)ExpandItemLCA.INSTANCE;
        }
        return super.getAdapter(adapter);
    }

    private void updateBounds() {
        int parentWidth = this.parent.computeSize((int)-1, (int)-1, (boolean)false).x;
        int scrollBarWidth = this.parent.getVScrollBarWidth();
        int availableWidth = parentWidth - 2 * this.parent.spacing - scrollBarWidth;
        this.width = Math.max(this.getPreferredWidth(), availableWidth);
        this.setBounds(0, 0, this.width, this.height, false, true);
    }

    BoxDimensions getItemBorder() {
        return this.getExpandBarThemeAdapter().getItemBorder(this.parent);
    }

    BoxDimensions getItemHeaderBorder() {
        return this.getExpandBarThemeAdapter().getItemHeaderBorder(this.parent);
    }

    private ExpandBarThemeAdapter getExpandBarThemeAdapter() {
        return (ExpandBarThemeAdapter)this.parent.getAdapter(ThemeAdapter.class);
    }
}

