/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.http.servlet.internal.servlet;

import jakarta.servlet.Filter;
import jakarta.servlet.RequestDispatcher;
import jakarta.servlet.Servlet;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletContextAttributeEvent;
import jakarta.servlet.ServletContextAttributeListener;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.URL;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.rap.http.servlet.internal.context.ContextController;
import org.eclipse.rap.http.servlet.internal.context.DispatchTargets;
import org.eclipse.rap.http.servlet.internal.context.ProxyContext;
import org.eclipse.rap.http.servlet.internal.servlet.Match;
import org.eclipse.rap.http.servlet.internal.servlet.RequestDispatcherAdaptor;
import org.eclipse.rap.http.servlet.internal.util.EventListeners;
import org.eclipse.rap.service.servlet.internal.context.ServletContextHelper;
import org.osgi.framework.Bundle;
import org.osgi.framework.wiring.BundleWiring;

public class ServletContextAdaptor {
    private static final Map<Method, Method> contextToHandlerMethods = ServletContextAdaptor.createContextToHandlerMethods();
    private static final String SIMPLE_NAME = ServletContextAdaptor.class.getSimpleName();
    private static final ThreadLocal<ServletContext> servletContextTL = new ThreadLocal();
    private final AccessControlContext acc;
    private final Bundle bundle;
    private final ClassLoader classLoader;
    final ContextController contextController;
    private final EventListeners eventListeners;
    private final ProxyContext proxyContext;
    private final ServletContext servletContext;
    final ServletContextHelper servletContextHelper;
    private String string;

    private static Map<Method, Method> createContextToHandlerMethods() {
        Method[] handlerMethods;
        HashMap<Method, Method> methods = new HashMap<Method, Method>();
        Method[] methodArray = handlerMethods = ServletContextAdaptor.class.getDeclaredMethods();
        int n = handlerMethods.length;
        int n2 = 0;
        while (n2 < n) {
            Method handlerMethod = methodArray[n2];
            String name = handlerMethod.getName();
            Class<?>[] parameterTypes = handlerMethod.getParameterTypes();
            try {
                Method method = ServletContext.class.getMethod(name, parameterTypes);
                methods.put(method, handlerMethod);
            }
            catch (NoSuchMethodException noSuchMethodException) {}
            ++n2;
        }
        try {
            Method equalsMethod = Object.class.getMethod("equals", Object.class);
            Method equalsHandlerMethod = ServletContextAdaptor.class.getMethod("equals", Object.class);
            methods.put(equalsMethod, equalsHandlerMethod);
            Method hashCodeMethod = Object.class.getMethod("hashCode", null);
            Method hashCodeHandlerMethod = ServletContextAdaptor.class.getMethod("hashCode", null);
            methods.put(hashCodeMethod, hashCodeHandlerMethod);
        }
        catch (NoSuchMethodException noSuchMethodException) {}
        return methods;
    }

    public ServletContextAdaptor(ContextController contextController, Bundle bundle, ServletContextHelper servletContextHelper, EventListeners eventListeners, AccessControlContext acc) {
        this.contextController = contextController;
        this.proxyContext = contextController.getProxyContext();
        this.servletContext = this.proxyContext.getServletContext();
        this.servletContextHelper = servletContextHelper;
        this.eventListeners = eventListeners;
        this.acc = acc;
        this.bundle = bundle;
        BundleWiring bundleWiring = (BundleWiring)this.bundle.adapt(BundleWiring.class);
        this.classLoader = bundleWiring.getClassLoader();
    }

    public ServletContext createServletContext() {
        Class<?> clazz = this.getClass();
        ClassLoader curClassLoader = clazz.getClassLoader();
        Class[] interfaces = new Class[]{ServletContext.class};
        return (ServletContext)Proxy.newProxyInstance(curClassLoader, interfaces, (InvocationHandler)new AdaptorInvocationHandler());
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ServletContext)) {
            return false;
        }
        if (!Proxy.isProxyClass(obj.getClass())) {
            return false;
        }
        InvocationHandler invocationHandler = Proxy.getInvocationHandler(obj);
        if (!(invocationHandler instanceof AdaptorInvocationHandler)) {
            return false;
        }
        AdaptorInvocationHandler adaptorInvocationHandler = (AdaptorInvocationHandler)invocationHandler;
        return this.contextController.equals(adaptorInvocationHandler.getContextController());
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public String getContextPath() {
        return this.contextController.getFullContextPath();
    }

    public Object getAttribute(String attributeName) {
        Dictionary<String, Object> attributes = this.getContextAttributes();
        if (attributeName.equals("osgi-bundlecontext")) {
            return this.bundle.getBundleContext();
        }
        return attributes.get(attributeName);
    }

    public Enumeration<String> getAttributeNames() {
        Dictionary<String, Object> attributes = this.getContextAttributes();
        return attributes.keys();
    }

    public String getInitParameter(String name) {
        return this.contextController.getInitParams().get(name);
    }

    public Enumeration<String> getInitParameterNames() {
        return Collections.enumeration(this.contextController.getInitParams().keySet());
    }

    public String getMimeType(String name) {
        String mimeType = null;
        try {
            mimeType = AccessController.doPrivileged(() -> this.servletContextHelper.getMimeType(name), this.acc);
        }
        catch (PrivilegedActionException e) {
            this.servletContext.log(e.getException().getMessage(), (Throwable)e.getException());
        }
        return mimeType != null ? mimeType : this.servletContext.getMimeType(name);
    }

    public RequestDispatcher getNamedDispatcher(String servletName) {
        DispatchTargets dispatchTargets = this.contextController.getDispatchTargets(servletName, null, null, null, null, null, Match.EXACT, null);
        if (dispatchTargets == null) {
            return null;
        }
        return new RequestDispatcherAdaptor(dispatchTargets, servletName);
    }

    public String getRealPath(String path) {
        try {
            return AccessController.doPrivileged(() -> this.servletContextHelper.getRealPath(path), this.acc);
        }
        catch (PrivilegedActionException e) {
            this.servletContext.log(e.getException().getMessage(), (Throwable)e.getException());
            return null;
        }
    }

    public RequestDispatcher getRequestDispatcher(String path) {
        DispatchTargets dispatchTargets;
        if (!path.startsWith("/")) {
            return null;
        }
        if (path.startsWith(this.contextController.getFullContextPath())) {
            path = path.substring(this.contextController.getFullContextPath().length());
        }
        if ((dispatchTargets = this.contextController.getDispatchTargets(path, null)) == null) {
            return null;
        }
        return new RequestDispatcherAdaptor(dispatchTargets, path);
    }

    public URL getResource(String name) {
        try {
            return AccessController.doPrivileged(() -> this.servletContextHelper.getResource(name), this.acc);
        }
        catch (PrivilegedActionException e) {
            this.servletContext.log(e.getException().getMessage(), (Throwable)e.getException());
            return null;
        }
    }

    public InputStream getResourceAsStream(String name) {
        URL url = this.getResource(name);
        if (url != null) {
            try {
                return url.openStream();
            }
            catch (IOException ioe) {
                this.servletContext.log(ioe.getMessage(), (Throwable)ioe);
            }
        }
        return null;
    }

    public Set<String> getResourcePaths(String name) {
        if (name == null || !name.startsWith("/")) {
            return null;
        }
        try {
            return AccessController.doPrivileged(() -> this.servletContextHelper.getResourcePaths(name), this.acc);
        }
        catch (PrivilegedActionException e) {
            this.servletContext.log(e.getException().getMessage(), (Throwable)e.getException());
            return null;
        }
    }

    public String getServletContextName() {
        return this.contextController.getContextName();
    }

    public int hashCode() {
        return this.contextController.hashCode();
    }

    public void removeAttribute(String attributeName) {
        Dictionary<String, Object> attributes = this.getContextAttributes();
        Object attributeValue = attributes.remove(attributeName);
        List<ServletContextAttributeListener> listeners = this.eventListeners.get(ServletContextAttributeListener.class);
        if (listeners.isEmpty()) {
            return;
        }
        ServletContextAttributeEvent servletContextAttributeEvent = new ServletContextAttributeEvent(servletContextTL.get(), attributeName, attributeValue);
        for (ServletContextAttributeListener servletContextAttributeListener : listeners) {
            servletContextAttributeListener.attributeRemoved(servletContextAttributeEvent);
        }
    }

    public void addFilter(String arg1, Class<? extends Filter> arg2) {
        throw new UnsupportedOperationException();
    }

    public void addFilter(String arg1, String arg2) {
        throw new UnsupportedOperationException();
    }

    public void addFilter(String arg1, Filter arg2) {
        throw new UnsupportedOperationException();
    }

    public void addListener(Class<?> arg1) {
        throw new UnsupportedOperationException();
    }

    public void addListener(String arg1) {
        throw new UnsupportedOperationException();
    }

    public void addListener(EventListener arg1) {
        throw new UnsupportedOperationException();
    }

    public void addServlet(String arg1, Class<? extends Servlet> arg2) {
        throw new UnsupportedOperationException();
    }

    public void addServlet(String arg1, String arg2) {
        throw new UnsupportedOperationException();
    }

    public void addServlet(String arg1, Servlet arg2) {
        throw new UnsupportedOperationException();
    }

    public void createFilter(Class<?> arg1) {
        throw new UnsupportedOperationException();
    }

    public void createServlet(Class<?> arg1) {
        throw new UnsupportedOperationException();
    }

    public void createListener(Class<?> arg1) {
        throw new UnsupportedOperationException();
    }

    public void declareRoles(String ... arg1) {
        throw new UnsupportedOperationException();
    }

    public void setAttribute(String attributeName, Object attributeValue) {
        if (attributeValue == null) {
            this.removeAttribute(attributeName);
            return;
        }
        Dictionary<String, Object> attributes = this.getContextAttributes();
        boolean added = attributes.get(attributeName) == null;
        attributes.put(attributeName, attributeValue);
        List<ServletContextAttributeListener> listeners = this.eventListeners.get(ServletContextAttributeListener.class);
        if (listeners.isEmpty()) {
            return;
        }
        ServletContextAttributeEvent servletContextAttributeEvent = new ServletContextAttributeEvent(servletContextTL.get(), attributeName, attributeValue);
        for (ServletContextAttributeListener servletContextAttributeListener : listeners) {
            if (added) {
                servletContextAttributeListener.attributeAdded(servletContextAttributeEvent);
                continue;
            }
            servletContextAttributeListener.attributeReplaced(servletContextAttributeEvent);
        }
    }

    public String toString() {
        String value = this.string;
        if (value == null) {
            this.string = value = String.valueOf(SIMPLE_NAME) + '[' + this.contextController + ']';
        }
        return value;
    }

    Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        boolean useThreadLocal;
        boolean bl = useThreadLocal = "removeAttribute".equals(method.getName()) || "setAttribute".equals(method.getName());
        if (useThreadLocal) {
            servletContextTL.set((ServletContext)proxy);
        }
        try {
            block9: {
                Method m = contextToHandlerMethods.get(method);
                try {
                    if (m == null) break block9;
                    Object object = m.invoke((Object)this, args);
                    return object;
                }
                catch (InvocationTargetException e) {
                    throw e.getCause();
                }
            }
            Object object = method.invoke((Object)this.servletContext, args);
            return object;
        }
        finally {
            if (useThreadLocal) {
                servletContextTL.remove();
            }
        }
    }

    private Dictionary<String, Object> getContextAttributes() {
        return this.proxyContext.getContextAttributes(this.contextController);
    }

    private class AdaptorInvocationHandler
    implements InvocationHandler {
        public ContextController getContextController() {
            return ServletContextAdaptor.this.contextController;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            return ServletContextAdaptor.this.invoke(proxy, method, args);
        }
    }
}

