/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.auth.win;

import org.apache.http.annotation.Contract;
import org.apache.http.annotation.ThreadingBehavior;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.impl.auth.win.CurrentWindowsCredentials;
import org.apache.http.util.Args;

@Contract(threading=ThreadingBehavior.SAFE)
public class WindowsCredentialsProvider
implements CredentialsProvider {
    private final CredentialsProvider provider;

    public WindowsCredentialsProvider(CredentialsProvider provider) {
        this.provider = (CredentialsProvider)Args.notNull((Object)provider, (String)"Credentials provider");
    }

    public Credentials getCredentials(AuthScope authscope) {
        String scheme = authscope.getScheme();
        if ("NTLM".equalsIgnoreCase(scheme) || "Negotiate".equalsIgnoreCase(scheme)) {
            return CurrentWindowsCredentials.INSTANCE;
        }
        return this.provider.getCredentials(authscope);
    }

    public void setCredentials(AuthScope authscope, Credentials credentials) {
        this.provider.setCredentials(authscope, credentials);
    }

    public void clear() {
        this.provider.clear();
    }
}

