/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.reqcycle.utils.ocl.internal;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.ocl.EvaluationEnvironment;
import org.eclipse.ocl.ecore.EcoreEvaluationEnvironment;
import org.eclipse.ocl.util.Tuple;
import org.polarsys.reqcycle.utils.ocl.extensions.JavaImplementedOCLOperation;

public class CustomEvaluationEnvironment
extends EcoreEvaluationEnvironment
implements EvaluationEnvironment<EClassifier, EOperation, EStructuralFeature, EClass, EObject> {
    private Map<String, JavaImplementedOCLOperation> customOperations = new HashMap<String, JavaImplementedOCLOperation>();
    private EcoreEvaluationEnvironment baseEvaluationEnvironment;

    public CustomEvaluationEnvironment() {
    }

    protected CustomEvaluationEnvironment(EvaluationEnvironment<EClassifier, EOperation, EStructuralFeature, EClass, EObject> parent) {
        super(parent);
    }

    public void setBaseEvaluationEnvironment(EcoreEvaluationEnvironment baseEvaluationEnvironment) {
        this.baseEvaluationEnvironment = baseEvaluationEnvironment;
    }

    public void addCustomJavaOperation(JavaImplementedOCLOperation operation) {
        this.customOperations.put(operation.getName(), operation);
    }

    public Object callOperation(EOperation operation, int opcode, Object source, Object[] args) throws IllegalArgumentException {
        String operationName = operation.getName();
        JavaImplementedOCLOperation customOperation = this.customOperations.get(operationName);
        if (customOperation != null && customOperation.check(source, args)) {
            return customOperation.execute(source, args);
        }
        int i = 0;
        while (i < args.length) {
            if (args[i] == null) {
                StringBuilder message = new StringBuilder("NULL ARGUMENT WARNING : ");
                message.append(operationName);
                message.append(" on element ");
                message.append(source.toString());
                message.append(" with argument number " + i + " null");
                message.append(args.toString());
                throw new IllegalArgumentException(message.toString());
            }
            ++i;
        }
        return this.baseEvaluationEnvironment.callOperation(operation, opcode, source, args);
    }

    public Object getValueOf(String name) {
        return this.baseEvaluationEnvironment.getValueOf(name);
    }

    public void replace(String name, Object value) {
        this.baseEvaluationEnvironment.replace(name, value);
    }

    public void add(String name, Object value) {
        this.baseEvaluationEnvironment.add(name, value);
    }

    public Object remove(String name) {
        return this.baseEvaluationEnvironment.remove(name);
    }

    public void clear() {
        this.baseEvaluationEnvironment.clear();
    }

    public boolean overrides(EOperation operation, int opcode) {
        return this.baseEvaluationEnvironment.overrides((Object)operation, opcode);
    }

    public Object navigateProperty(EStructuralFeature property, List<?> qualifiers, Object source) throws IllegalArgumentException {
        return this.baseEvaluationEnvironment.navigateProperty(property, qualifiers, source);
    }

    public Object navigateAssociationClass(EClassifier associationClass, EStructuralFeature navigationSource, Object source) throws IllegalArgumentException {
        return this.baseEvaluationEnvironment.navigateAssociationClass(associationClass, navigationSource, source);
    }

    public Map<EClass, Set<EObject>> createExtentMap(Object object) {
        return this.baseEvaluationEnvironment.createExtentMap(object);
    }

    public boolean isKindOf(Object object, EClassifier classifier) {
        return this.baseEvaluationEnvironment.isKindOf(object, classifier);
    }

    public boolean isTypeOf(Object object, EClassifier classifier) {
        return this.baseEvaluationEnvironment.isTypeOf(object, classifier);
    }

    public EClassifier getType(Object object) {
        return this.baseEvaluationEnvironment.getType(object);
    }

    public Tuple<EOperation, EStructuralFeature> createTuple(EClassifier type, Map<EStructuralFeature, Object> values) {
        return this.baseEvaluationEnvironment.createTuple(type, values);
    }
}

