/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.reqcycle.traceability.storage.sesame.storage;

import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.ExecutionException;
import javax.inject.Inject;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.openrdf.OpenRDFException;
import org.openrdf.repository.RepositoryConnection;
import org.openrdf.repository.RepositoryException;
import org.polarsys.reqcycle.traceability.storage.IOneFileStorageProvider;
import org.polarsys.reqcycle.traceability.storage.IStorageProvider;
import org.polarsys.reqcycle.traceability.storage.ITraceabilityStorage;
import org.polarsys.reqcycle.traceability.storage.NoProjectStorageException;
import org.polarsys.reqcycle.traceability.storage.sesame.exceptions.SesameStorageRuntimeException;
import org.polarsys.reqcycle.traceability.storage.sesame.storage.SesameTraceabilityStorage;
import org.polarsys.reqcycle.traceability.storage.sesame.storage.repositoryholders.SesameBinaryRepositoryHolder;
import org.polarsys.reqcycle.traceability.storage.sesame.storage.repositoryholders.SesameXMLRepositoryHolder;
import org.polarsys.reqcycle.traceability.storage.sesame.storage.savetriggers.DummySaveTrigger;
import org.polarsys.reqcycle.traceability.storage.sesame.storage.savetriggers.ISaveTrigger;
import org.polarsys.reqcycle.uri.IReachableManager;
import org.polarsys.reqcycle.uri.exceptions.IReachableHandlerException;
import org.polarsys.reqcycle.uri.model.Reachable;
import org.polarsys.reqcycle.uri.model.ReachableObject;
import org.polarsys.reqcycle.utils.inject.ZigguratInject;

public class SesameStorageProvider
implements IStorageProvider,
IOneFileStorageProvider {
    @Inject
    private IEventBroker broker;
    @Inject
    private SesameBinaryRepositoryHolder binaryRepositoryHolder;
    @Inject
    private SesameXMLRepositoryHolder xmlRepositoryHolder;
    @Inject
    protected IReachableManager manager;

    public ITraceabilityStorage getStorage(String path) {
        try {
            RepositoryConnection connection = this.binaryRepositoryHolder.getConnection(path);
            ISaveTrigger saveTrigger = this.binaryRepositoryHolder.getSaveTrigger(path);
            SesameTraceabilityStorage traceabilityStorage = new SesameTraceabilityStorage(this, path, connection, saveTrigger);
            ZigguratInject.inject((Object[])new Object[]{traceabilityStorage});
            return traceabilityStorage;
        }
        catch (RepositoryException e) {
            throw new SesameStorageRuntimeException("Error initializing storage repository", e);
        }
        catch (ExecutionException e) {
            throw new SesameStorageRuntimeException("Error initializing storage repository", e);
        }
    }

    public ITraceabilityStorage getStorageReader(InputStream inputStream) {
        try {
            RepositoryConnection connection = this.xmlRepositoryHolder.getConnection(inputStream);
            return new SesameTraceabilityStorage(this, "", connection, new DummySaveTrigger());
        }
        catch (OpenRDFException e) {
            throw new SesameStorageRuntimeException("Error initializing storage repository", e);
        }
        catch (IOException e) {
            throw new SesameStorageRuntimeException("Error initializing storage repository", e);
        }
        catch (ExecutionException e) {
            throw new SesameStorageRuntimeException("Error initializing storage repository", e);
        }
    }

    public ITraceabilityStorage getProjectStorage(IProject project) {
        try {
            RepositoryConnection connection = this.xmlRepositoryHolder.getConnection(project);
            ISaveTrigger saveTrigger = this.xmlRepositoryHolder.getSaveTrigger(project);
            String pathUri = this.xmlRepositoryHolder.getTargetFile(project).toURI().toString();
            SesameTraceabilityStorage sesameTraceabilityStorage = new SesameTraceabilityStorage(this, pathUri, connection, saveTrigger);
            ZigguratInject.inject((Object[])new Object[]{sesameTraceabilityStorage});
            return sesameTraceabilityStorage;
        }
        catch (RepositoryException e) {
            throw new SesameStorageRuntimeException("Error initializing storage repository", e);
        }
        catch (ExecutionException e) {
            throw new SesameStorageRuntimeException("Error initializing storage repository", e);
        }
    }

    public void notifyChanged(String event, Object data) {
        this.broker.post(event, data);
    }

    public ITraceabilityStorage getProjectStorageFromLinkId(Reachable reachable) throws NoProjectStorageException {
        try {
            IFile adapted;
            ReachableObject object = this.manager.getHandlerFromReachable(reachable).getFromReachable(reachable);
            if (object != null && (adapted = (IFile)object.getAdapter(IFile.class)) != null) {
                IProject p = adapted.getProject();
                return this.getProjectStorage(p);
            }
        }
        catch (IReachableHandlerException e) {
            throw new NoProjectStorageException((Throwable)e);
        }
        throw new NoProjectStorageException("Unable to create project storage from reachable");
    }
}

