/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.reqcycle.utils.iterators.collectors;

import org.polarsys.reqcycle.utils.iterators.Activator;
import org.polarsys.reqcycle.utils.iterators.collectors.Harvester;
import org.polarsys.reqcycle.utils.iterators.exceptions.CannotHandleException;
import org.polarsys.reqcycle.utils.iterators.exceptions.CollectionAbortedException;
import org.polarsys.reqcycle.utils.iterators.handlers.ResultHandler;
import org.polarsys.reqcycle.utils.iterators.pickers.IPicker;

public class DepthHarvester
extends Harvester {
    public DepthHarvester() {
    }

    public DepthHarvester(Object startingElement) {
        super(startingElement);
    }

    @Override
    public void collect(ResultHandler<Object> handler) throws CollectionAbortedException {
        this.collectDepthWise(handler, this.start);
    }

    protected void collectDepthWise(ResultHandler<Object> handler, Object element) throws CollectionAbortedException {
        try {
            handler.handleResult(element);
            for (IPicker picker : this.getPickers()) {
                Iterable<?> nexts = picker.getNexts(element);
                if (nexts == null) continue;
                for (Object next : nexts) {
                    this.collectDepthWise(handler, next);
                }
            }
        }
        catch (CannotHandleException cannotHandleException) {
        }
        catch (Exception e) {
            Activator.logError(e);
        }
    }
}

