/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.doc.doc2model.tikaparsing.pdf;

import org.polarsys.kitalpha.doc.doc2model.tikaparsing.pdf.Chunk;
import org.polarsys.kitalpha.doc.doc2model.tikaparsing.pdf.Paragraph;
import org.polarsys.kitalpha.doc.doc2model.tikaparsing.pdf.ParagraphDecorator;

public class ScoreParagraph
extends ParagraphDecorator {
    private float _scoreSize = 0.0f;
    private boolean _bold = false;

    public float getScoreSize() {
        return this._scoreSize;
    }

    public boolean isBold() {
        return this._bold;
    }

    public ScoreParagraph(Paragraph para) {
        super(para);
        float sizeBold = 0.0f;
        int nb_char = 0;
        int chunk_char = 0;
        for (Chunk elt : this.getChunks()) {
            chunk_char = elt.getText().length();
            nb_char += chunk_char;
            this._scoreSize += elt.getStyle().get_fontSize() * (float)chunk_char;
            sizeBold += (float)((elt.getStyle().is_bold() ? 1 : 0) * chunk_char);
        }
        if (nb_char > 0) {
            this._scoreSize /= (float)nb_char;
            this._bold = (double)(sizeBold / (float)nb_char) > 0.5;
        }
    }

    @Override
    public String toString() {
        return String.valueOf(super.toString()) + "Score: " + this._scoreSize + "| Bold: " + this._bold;
    }
}

