/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.reqcycle.styling.ui.dialogs;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.databinding.EMFObservables;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.databinding.viewers.IViewerObservableValue;
import org.eclipse.jface.databinding.viewers.ViewerProperties;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wb.swt.ResourceManager;
import org.eclipse.wb.swt.SWTResourceManager;
import org.polarsys.reqcycle.predicates.core.api.IPredicate;
import org.polarsys.reqcycle.predicates.persistance.util.IPredicatesConfManager;
import org.polarsys.reqcycle.styling.manager.IStylingManager;
import org.polarsys.reqcycle.styling.model.Styling.CaseStyle;
import org.polarsys.reqcycle.styling.model.Styling.ConstantPattern;
import org.polarsys.reqcycle.styling.model.Styling.FontOption;
import org.polarsys.reqcycle.styling.model.Styling.Pattern;
import org.polarsys.reqcycle.styling.model.Styling.Segment;
import org.polarsys.reqcycle.styling.model.Styling.StylingFactory;
import org.polarsys.reqcycle.styling.model.Styling.StylingModel;
import org.polarsys.reqcycle.styling.model.Styling.StylingPackage;
import org.polarsys.reqcycle.styling.model.Styling.StylingPredicate;
import org.polarsys.reqcycle.styling.model.Styling.util.StylingAdapterFactory;
import org.polarsys.reqcycle.styling.ui.dialogs.IconRegistry;
import org.polarsys.reqcycle.styling.ui.dialogs.PictureChooserDialog;
import org.polarsys.reqcycle.styling.ui.dialogs.SegmentEditorDialog;
import org.polarsys.reqcycle.utils.inject.ZigguratInject;

public class StyleModelEditorDialog
extends TitleAreaDialog
implements IDoubleClickListener {
    IStylingManager styleManager = (IStylingManager)ZigguratInject.make(IStylingManager.class);
    IPredicatesConfManager predicatesConfManager = (IPredicatesConfManager)ZigguratInject.make(IPredicatesConfManager.class);
    private ListViewer listViewer;
    private StyledText styledText;
    private CaseStyle caseStyle;
    private StylingModel stylingModel;
    private Combo combo;
    private ComboViewer comboViewer;
    private Label iconLabel;

    public StyleModelEditorDialog(Shell parentShell, CaseStyle style, StylingModel styling) {
        super(parentShell);
        this.setShellStyle(35952);
        this.caseStyle = style;
        if (this.caseStyle.getIcon() == null) {
            this.caseStyle.setIcon(StylingFactory.eINSTANCE.createIcon());
            this.caseStyle.getIcon().setImage("");
        }
        this.stylingModel = styling;
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle("Styling predicate editor");
        Composite area = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(area, 0);
        container.setLayout((Layout)new GridLayout(2, false));
        container.setLayoutData((Object)new GridData(1808));
        if (this.caseStyle instanceof StylingPredicate) {
            Label lblName = new Label(container, 0);
            lblName.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
            lblName.setText("Predicate : ");
            this.comboViewer = new ComboViewer(container, 8);
            this.combo = this.comboViewer.getCombo();
            this.combo.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        }
        Group composite = new Group(container, 0);
        composite.setText("Segments");
        composite.setLayout((Layout)new GridLayout(2, false));
        composite.setLayoutData((Object)new GridData(4, 4, true, true, 2, 2));
        composite.setBounds(0, 0, 64, 64);
        this.listViewer = new ListViewer((Composite)composite, 67584);
        List list = this.listViewer.getList();
        list.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.listViewer.addDoubleClickListener((IDoubleClickListener)this);
        Composite compositeBtn = new Composite((Composite)composite, 0);
        compositeBtn.setLayoutData((Object)new GridData(16384, 128, false, false, 1, 1));
        GridLayout gl_compositeBtn = new GridLayout(1, false);
        gl_compositeBtn.marginHeight = 0;
        gl_compositeBtn.verticalSpacing = 0;
        gl_compositeBtn.horizontalSpacing = 0;
        compositeBtn.setLayout((Layout)gl_compositeBtn);
        Button btnAdd = new Button(compositeBtn, 0);
        btnAdd.setToolTipText("Add new segment");
        btnAdd.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EList segmentList = StyleModelEditorDialog.this.caseStyle.getSegments();
                Segment newSegment = StylingFactory.eINSTANCE.createSegment();
                ConstantPattern pattern = StylingFactory.eINSTANCE.createConstantPattern();
                pattern.setValue("New segment");
                newSegment.setPattern((Pattern)pattern);
                newSegment.setStyle(StylingFactory.eINSTANCE.createStyle());
                newSegment.setColor(new Color((Device)Display.getDefault(), 0, 0, 0));
                segmentList.add((Object)newSegment);
                StyleModelEditorDialog.this.listViewer.setInput((Object)StyleModelEditorDialog.this.caseStyle.getSegments());
                StyleModelEditorDialog.this.listViewer.setSelection((ISelection)new StructuredSelection((Object)newSegment));
                StyleModelEditorDialog.this.handlePreview();
            }
        });
        btnAdd.setImage(ResourceManager.getPluginImage("org.polarsys.reqcycle.styling.ui", "icons/add_obj.gif"));
        Button btnRemove = new Button(compositeBtn, 0);
        btnRemove.setToolTipText("Remove selected segment");
        btnRemove.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection;
                Segment segment;
                if (!StyleModelEditorDialog.this.listViewer.getSelection().isEmpty() && (segment = (Segment)(selection = (IStructuredSelection)StyleModelEditorDialog.this.listViewer.getSelection()).getFirstElement()) != null) {
                    EList segmentList = StyleModelEditorDialog.this.caseStyle.getSegments();
                    segmentList.remove((Object)segment);
                    StyleModelEditorDialog.this.listViewer.setInput((Object)StyleModelEditorDialog.this.caseStyle.getSegments());
                    StyleModelEditorDialog.this.handlePreview();
                }
            }
        });
        btnRemove.setImage(ResourceManager.getPluginImage("org.polarsys.reqcycle.styling.ui", "icons/delete_obj.gif"));
        Button btnEdit = new Button(compositeBtn, 0);
        btnEdit.setToolTipText("Edit selected segment");
        btnEdit.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection;
                Segment segment;
                if (!StyleModelEditorDialog.this.listViewer.getSelection().isEmpty() && (segment = (Segment)(selection = (IStructuredSelection)StyleModelEditorDialog.this.listViewer.getSelection()).getFirstElement()) != null) {
                    StyleModelEditorDialog.this.editSegment(segment);
                }
            }
        });
        btnEdit.setImage(ResourceManager.getPluginImage("org.polarsys.reqcycle.styling.ui", "icons/edit_obj.png"));
        btnEdit.setBounds(0, 0, 75, 25);
        Button btnUp = new Button(compositeBtn, 0);
        btnUp.setToolTipText("Move up selected segment");
        btnUp.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EList segmentList;
                int pos;
                IStructuredSelection selection;
                Segment segment;
                if (!StyleModelEditorDialog.this.listViewer.getSelection().isEmpty() && (segment = (Segment)(selection = (IStructuredSelection)StyleModelEditorDialog.this.listViewer.getSelection()).getFirstElement()) != null && (pos = (segmentList = StyleModelEditorDialog.this.caseStyle.getSegments()).indexOf((Object)segment)) > 0) {
                    segmentList.move(pos, pos - 1);
                    StyleModelEditorDialog.this.listViewer.setInput((Object)StyleModelEditorDialog.this.caseStyle.getSegments());
                    StyleModelEditorDialog.this.listViewer.setSelection((ISelection)selection);
                    StyleModelEditorDialog.this.handlePreview();
                }
            }
        });
        btnUp.setImage(ResourceManager.getPluginImage("org.polarsys.reqcycle.styling.ui", "icons/prev_nav-1.gif"));
        btnUp.setBounds(0, 0, 75, 25);
        Button btnDown = new Button(compositeBtn, 0);
        btnDown.setToolTipText("Move down selected segment");
        btnDown.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EList segmentList;
                int pos;
                IStructuredSelection selection;
                Segment segment;
                if (!StyleModelEditorDialog.this.listViewer.getSelection().isEmpty() && (segment = (Segment)(selection = (IStructuredSelection)StyleModelEditorDialog.this.listViewer.getSelection()).getFirstElement()) != null && (pos = (segmentList = StyleModelEditorDialog.this.caseStyle.getSegments()).indexOf((Object)segment)) != -1 && pos != segmentList.size() - 1) {
                    segmentList.move(pos, pos + 1);
                    StyleModelEditorDialog.this.listViewer.setInput((Object)StyleModelEditorDialog.this.caseStyle.getSegments());
                    StyleModelEditorDialog.this.listViewer.setSelection((ISelection)selection);
                    StyleModelEditorDialog.this.handlePreview();
                }
            }
        });
        btnDown.setImage(ResourceManager.getPluginImage("org.polarsys.reqcycle.styling.ui", "icons/next_nav-1.gif"));
        if (this.caseStyle instanceof StylingPredicate) {
            this.comboViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
            ComposedAdapterFactory adapterfactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
            AdapterFactoryLabelProvider labelProvider = new AdapterFactoryLabelProvider((AdapterFactory)adapterfactory){

                public String getText(Object object) {
                    if (object instanceof IPredicate) {
                        return ((IPredicate)object).getDisplayName();
                    }
                    return super.getText(object);
                }
            };
            this.comboViewer.setLabelProvider((IBaseLabelProvider)labelProvider);
            Collection predicates = this.predicatesConfManager.getPredicates(false);
            final Iterable alreadyUsed = Iterables.filter((Iterable)Iterables.transform((Iterable)this.stylingModel.getStyles(), (Function)new Function<CaseStyle, IPredicate>(){

                public IPredicate apply(CaseStyle arg0) {
                    if (arg0 instanceof StylingPredicate) {
                        StylingPredicate sp = (StylingPredicate)arg0;
                        return sp.getPredicate();
                    }
                    return null;
                }
            }), (Predicate)Predicates.notNull());
            ArrayList selectionPredicates = Lists.newArrayList((Iterable)Iterables.filter((Iterable)predicates, (Predicate)new Predicate<IPredicate>(){

                public boolean apply(IPredicate arg0) {
                    for (IPredicate p : alreadyUsed) {
                        if (p == null || p.getDisplayName() == null || !p.getDisplayName().equals(arg0.getDisplayName())) continue;
                        return false;
                    }
                    return true;
                }
            }));
            IPredicate predicate = ((StylingPredicate)this.caseStyle).getPredicate();
            if (predicate != null) {
                selectionPredicates.add(predicate);
            }
            if (selectionPredicates != null && selectionPredicates.size() > 0) {
                this.comboViewer.setInput((Object)selectionPredicates);
            }
            if (predicate != null) {
                this.comboViewer.setSelection((ISelection)new StructuredSelection((Object)predicate));
            }
        }
        this.initProviders(this.listViewer);
        Label lblIcon = new Label(container, 0);
        lblIcon.setText("Icon :");
        Button btnNewButton = new Button(container, 0);
        btnNewButton.setToolTipText("Select icon");
        btnNewButton.setText("...");
        btnNewButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PictureChooserDialog d = new PictureChooserDialog(StyleModelEditorDialog.this.getShell(), StyleModelEditorDialog.this.caseStyle.getIcon().getImage());
                if (d.open() == 0) {
                    StyleModelEditorDialog.this.caseStyle.getIcon().setImage(d.imageSelected);
                    Display.getDefault().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            StyleModelEditorDialog.this.iconLabel.setImage(IconRegistry.getImage(StyleModelEditorDialog.this.caseStyle.getIcon().getImage()));
                        }
                    });
                }
            }
        });
        Group grpPreview = new Group(container, 0);
        GridData gd_grpPreview = new GridData(16384, 0x1000000, false, false, 2, 1);
        gd_grpPreview.widthHint = 393;
        grpPreview.setLayoutData((Object)gd_grpPreview);
        grpPreview.setText("Preview");
        grpPreview.setLayout((Layout)new GridLayout(2, false));
        this.iconLabel = new Label((Composite)grpPreview, 0);
        if (this.caseStyle.getIcon().getImage().equals("")) {
            Collection<IconRegistry.Descriptor> listDesc = IconRegistry.getRegisteredImages();
            if (listDesc.size() != 0) {
                IconRegistry.Descriptor desc = listDesc.iterator().next();
                this.caseStyle.getIcon().setImage(desc.id);
                this.iconLabel.setImage(IconRegistry.getImage(desc.id));
            }
        } else {
            this.iconLabel.setImage(IconRegistry.getImage(this.caseStyle.getIcon().getImage()));
        }
        this.styledText = new StyledText((Composite)grpPreview, 0);
        this.styledText.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        this.styledText.setBackground(SWTResourceManager.getColor(22));
        this.styledText.setAlignment(0x1000000);
        this.styledText.setEditable(false);
        this.styledText.setEnabled(false);
        this.handlePreview();
        return area;
    }

    private void handlePreview() {
        int pos = 0;
        EList segmentList = this.caseStyle.getSegments();
        this.styledText.setText("");
        int i = 0;
        while (i < segmentList.size()) {
            Segment segment = (Segment)segmentList.get(i);
            this.styledText.append(segment.getPattern().getPattern());
            StyleRange style = new StyleRange();
            style.foreground = segment.getColor();
            style.start = pos;
            style.length = segment.getPattern().getPattern().length();
            int font = 0;
            if (segment.getStyle().getAppliedFonts().contains((Object)FontOption.BOLD)) {
                font |= 1;
            }
            if (segment.getStyle().getAppliedFonts().contains((Object)FontOption.ITALIC)) {
                font |= 2;
            }
            if (segment.getStyle().getAppliedFonts().contains((Object)FontOption.UNDERLINE)) {
                style.underline = true;
            }
            if (segment.getStyle().getAppliedFonts().contains((Object)FontOption.STRIKE)) {
                style.strikeout = true;
            }
            style.font = SWTResourceManager.getFont("Segoe UI", 9, font);
            this.styledText.setStyleRange(style);
            pos += segment.getPattern().getPattern().length();
            ++i;
        }
    }

    private void initProviders(ListViewer list) {
        StylingAdapterFactory adapterfactory = new StylingAdapterFactory();
        AdapterFactoryLabelProvider labelProvider = new AdapterFactoryLabelProvider((AdapterFactory)adapterfactory){

            public String getText(Object object) {
                if (object instanceof Segment) {
                    return ((Segment)object).getPattern().getPattern();
                }
                return super.getText(object);
            }
        };
        ArrayContentProvider contentProvider = ArrayContentProvider.getInstance();
        list.setLabelProvider((IBaseLabelProvider)labelProvider);
        list.setContentProvider((IContentProvider)contentProvider);
        list.setInput((Object)this.caseStyle.getSegments());
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        if (this.caseStyle instanceof StylingPredicate) {
            this.initDataBindings();
        }
    }

    protected Point getInitialSize() {
        return new Point(428, 497);
    }

    protected DataBindingContext initDataBindings() {
        DataBindingContext bindingContext = new DataBindingContext();
        IViewerObservableValue observeSingleSelectionComboViewer = ViewerProperties.singleSelection().observe((Viewer)this.comboViewer);
        IObservableValue caseStylePredicateObserveValue = EMFObservables.observeValue((EObject)this.caseStyle, (EStructuralFeature)StylingPackage.Literals.STYLING_PREDICATE__PREDICATE);
        bindingContext.bindValue((IObservableValue)observeSingleSelectionComboViewer, caseStylePredicateObserveValue, null, null);
        return bindingContext;
    }

    private void editSegment(Segment segment) {
        SegmentEditorDialog editor = new SegmentEditorDialog(Display.getDefault().getActiveShell(), segment);
        if (editor.open() == 0) {
            this.listViewer.setInput((Object)this.caseStyle.getSegments());
            this.handlePreview();
        }
    }

    public void doubleClick(DoubleClickEvent event) {
        IStructuredSelection selection = (IStructuredSelection)event.getSelection();
        if (selection.getFirstElement() instanceof Segment) {
            this.editSegment((Segment)selection.getFirstElement());
        }
    }
}

