/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.reqcycle.ui.eattrpropseditor.api;

import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.polarsys.reqcycle.ui.eattrpropseditor.api.AbstractPropsEditorComponent;

public abstract class AbstractPropsTextEditorComponent<T>
extends AbstractPropsEditorComponent<T> {
    private static final Image ERROR_IMAGE = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_ERROR").getImage();
    private final Text text;
    private ControlDecoration controlDecoration;
    private String currentTextValue;

    public AbstractPropsTextEditorComponent(String attributeName, Class<T> type, Composite parent, int style) {
        super(type, parent, style);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginRight = 10;
        this.setLayout((Layout)gridLayout);
        Label lblName = new Label((Composite)this, 0);
        lblName.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false, 1, 1));
        lblName.setText(attributeName);
        this.text = new Text((Composite)this, 2048);
        this.text.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        if (this.useControlDecoration()) {
            this.controlDecoration = new ControlDecoration((Control)this.text, 131200);
            this.controlDecoration.setShowOnlyOnFocus(true);
            this.controlDecoration.setShowHover(true);
            this.controlDecoration.setMarginWidth(3);
        }
        this.text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AbstractPropsTextEditorComponent.this.currentTextValue = AbstractPropsTextEditorComponent.this.text.getText();
                if (AbstractPropsTextEditorComponent.this.isTextValid(AbstractPropsTextEditorComponent.this.currentTextValue)) {
                    if (AbstractPropsTextEditorComponent.this.useControlDecoration()) {
                        AbstractPropsTextEditorComponent.this.getControlDecoration().setImage(null);
                    }
                    AbstractPropsTextEditorComponent.this.setValue(AbstractPropsTextEditorComponent.this.convertFromString(AbstractPropsTextEditorComponent.this.currentTextValue));
                } else {
                    if (AbstractPropsTextEditorComponent.this.useControlDecoration()) {
                        AbstractPropsTextEditorComponent.this.getControlDecoration().setImage(ERROR_IMAGE);
                        AbstractPropsTextEditorComponent.this.getControlDecoration().setDescriptionText(AbstractPropsTextEditorComponent.this.getErrorMessage());
                    }
                    AbstractPropsTextEditorComponent.this.setValue(null);
                }
            }
        });
    }

    @Override
    public boolean isValid() {
        if (this.currentTextValue != null) {
            return this.isTextValid(this.currentTextValue);
        }
        return false;
    }

    @Override
    public void setInitialValue(Object object) {
        this.text.setText(object.toString());
    }

    protected abstract T convertFromString(String var1);

    protected abstract boolean isTextValid(String var1);

    protected boolean useControlDecoration() {
        return true;
    }

    protected ControlDecoration getControlDecoration() {
        return this.controlDecoration;
    }

    protected String getErrorMessage() {
        return "The input is not valid.";
    }
}

