/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.reqcycle.predicates.core.api;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum OPERATOR implements Enumerator
{
    EQ(0, "EQ", "="),
    NQ(1, "NQ", "!="),
    GT(2, "GT", ">"),
    GET(3, "GET", ">="),
    LT(4, "LT", "<"),
    LET(5, "LET", "<=");

    public static final int EQ_VALUE = 0;
    public static final int NQ_VALUE = 1;
    public static final int GT_VALUE = 2;
    public static final int GET_VALUE = 3;
    public static final int LT_VALUE = 4;
    public static final int LET_VALUE = 5;
    private static final OPERATOR[] VALUES_ARRAY;
    public static final List<OPERATOR> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new OPERATOR[]{EQ, NQ, GT, GET, LT, LET};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static OPERATOR get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            OPERATOR result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static OPERATOR getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            OPERATOR result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static OPERATOR get(int value) {
        switch (value) {
            case 0: {
                return EQ;
            }
            case 1: {
                return NQ;
            }
            case 2: {
                return GT;
            }
            case 3: {
                return GET;
            }
            case 4: {
                return LT;
            }
            case 5: {
                return LET;
            }
        }
        return null;
    }

    private OPERATOR(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

