/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.reqcycle.traceability.types.configuration.preferences;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.polarsys.reqcycle.traceability.types.configuration.predicates.ReqCycleDynamicPackage;
import org.polarsys.reqcycle.traceability.types.configuration.preferences.AbstractPreferencePage;
import org.polarsys.reqcycle.traceability.types.configuration.preferences.dialogs.NewAttributeDialog;
import org.polarsys.reqcycle.traceability.types.configuration.preferences.dialogs.NewRelationDialog;
import org.polarsys.reqcycle.traceability.types.configuration.typeconfiguration.Attribute;
import org.polarsys.reqcycle.traceability.types.configuration.typeconfiguration.Configuration;
import org.polarsys.reqcycle.traceability.types.configuration.typeconfiguration.Relation;
import org.polarsys.reqcycle.traceability.types.configuration.typeconfiguration.RelationsPredicatesMapping;
import org.polarsys.reqcycle.traceability.types.configuration.typeconfiguration.Type;
import org.polarsys.reqcycle.traceability.types.configuration.typeconfiguration.TypeConfigContainer;
import org.polarsys.reqcycle.utils.inject.ZigguratInject;

public class TraceabilityTypePreferencePage
extends AbstractPreferencePage {
    @Override
    protected ViewerFilter getFilter() {
        return new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                return !(element instanceof Type) && !(element instanceof RelationsPredicatesMapping);
            }
        };
    }

    @Override
    protected boolean removeCondition(EObject firstElement) {
        return !(firstElement instanceof TypeConfigContainer) && firstElement != null;
    }

    @Override
    protected void addAction() {
        if (this.treeViewer.getSelection() instanceof IStructuredSelection) {
            IStructuredSelection selec = (IStructuredSelection)this.treeViewer.getSelection();
            Object firstElement = selec.getFirstElement();
            if (firstElement == null) {
                this.createConfiguration();
            } else if (firstElement instanceof Relation) {
                this.createAttribute((Relation)firstElement);
            } else if (firstElement instanceof TypeConfigContainer) {
                this.createConfiguration();
            } else if (firstElement instanceof Configuration) {
                this.createRelation((Configuration)firstElement);
            }
        } else {
            this.createConfiguration();
        }
    }

    protected void createRelation(Configuration conf) {
        NewRelationDialog dialog = new NewRelationDialog(this.getShell(), this.container);
        ZigguratInject.inject((Object[])new Object[]{dialog});
        if (dialog.open() == 0) {
            conf.getRelations().add((Object)dialog.getRelation());
        }
    }

    private void createAttribute(Relation relation) {
        NewAttributeDialog dialog = new NewAttributeDialog(this.getShell(), this.container);
        ZigguratInject.inject((Object[])new Object[]{dialog});
        if (dialog.open() == 0) {
            relation.getAttributes().add((Object)((Attribute)EcoreUtil.copy((EObject)dialog.getAttribute())));
        }
    }

    @Override
    public boolean performOk() {
        boolean result = super.performOk();
        if (result) {
            ReqCycleDynamicPackage.reinitURIPackage();
        }
        return result;
    }

    @Override
    protected void removeAction() {
        IStructuredSelection new_name;
        EObject firstElement;
        if (this.treeViewer.getSelection() instanceof IStructuredSelection && this.removeCondition(firstElement = (EObject)(new_name = (IStructuredSelection)this.treeViewer.getSelection()).getFirstElement())) {
            EcoreUtil.delete((EObject)firstElement, (boolean)true);
        }
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.doLoad();
            this.setInput();
        }
        super.setVisible(visible);
    }
}

