/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.reqcycle.traceability.builder.ui.preferences;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ICheckStateProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.polarsys.reqcycle.traceability.builder.LabelledVisitor;
import org.polarsys.reqcycle.utils.configuration.IConfigurationManager;
import org.polarsys.reqcycle.utils.inject.ZigguratInject;

public class AnalysersPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    IConfigurationManager manager = (IConfigurationManager)ZigguratInject.make(IConfigurationManager.class);
    public static final String PREF_ID = "org.polarsys.reqcycle.traceability.builder.ui.disabledEngines";
    private Table table;
    private Label descriptionLabel;
    private Map<String, Object> prefs = new HashMap<String, Object>();
    private CheckboxTableViewer checkboxTableViewer;

    public AnalysersPreferencePage() {
        Map pref = this.manager.getSimpleConfiguration(null, IConfigurationManager.Scope.WORKSPACE, PREF_ID, true);
        if (pref != null) {
            this.prefs = pref;
        }
    }

    public Control createContents(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new FormLayout());
        Label lblNewLabel = new Label(container, 0);
        FormData fd_lblNewLabel = new FormData();
        fd_lblNewLabel.right = new FormAttachment(0, 365);
        fd_lblNewLabel.top = new FormAttachment(0);
        fd_lblNewLabel.left = new FormAttachment(0, 5);
        lblNewLabel.setLayoutData((Object)fd_lblNewLabel);
        lblNewLabel.setText("Checked analysers will be used for traceability analysis");
        this.checkboxTableViewer = CheckboxTableViewer.newCheckList((Composite)container, (int)67584);
        this.table = this.checkboxTableViewer.getTable();
        FormData fd_table = new FormData();
        fd_table.top = new FormAttachment((Control)lblNewLabel);
        fd_table.left = new FormAttachment(0, 5);
        fd_table.bottom = new FormAttachment(75);
        fd_table.right = new FormAttachment(100, -5);
        this.table.setLayoutData((Object)fd_table);
        this.checkboxTableViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof LabelledVisitor) {
                    LabelledVisitor visitor = (LabelledVisitor)element;
                    return visitor.getLabel();
                }
                return super.getText(element);
            }
        });
        this.checkboxTableViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.checkboxTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Object firstElement = ((IStructuredSelection)event.getSelection()).getFirstElement();
                if (firstElement instanceof LabelledVisitor) {
                    LabelledVisitor labelled = (LabelledVisitor)firstElement;
                    AnalysersPreferencePage.this.descriptionLabel.setText(labelled.getDescription());
                }
            }
        });
        this.checkboxTableViewer.setCheckStateProvider(new ICheckStateProvider(){

            public boolean isGrayed(Object element) {
                return false;
            }

            public boolean isChecked(Object element) {
                if (element instanceof LabelledVisitor) {
                    LabelledVisitor labelled = (LabelledVisitor)element;
                    return !Boolean.FALSE.equals(AnalysersPreferencePage.this.prefs.get(labelled.getVisitorClass().getName()));
                }
                return true;
            }
        });
        this.checkboxTableViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                Object element = event.getElement();
                if (element instanceof LabelledVisitor) {
                    LabelledVisitor labelled = (LabelledVisitor)element;
                    AnalysersPreferencePage.this.prefs.put(labelled.getVisitorClass().getName(), event.getChecked());
                }
            }
        });
        this.checkboxTableViewer.setInput((Object)LabelledVisitor.getRegisteredVisitors());
        Group grpDescription = new Group(container, 0);
        FormData fd_grpDescription = new FormData();
        fd_grpDescription.top = new FormAttachment((Control)this.table, 5);
        fd_grpDescription.bottom = new FormAttachment(100);
        fd_grpDescription.left = new FormAttachment(0, 5);
        fd_grpDescription.right = new FormAttachment(100, -5);
        grpDescription.setLayoutData((Object)fd_grpDescription);
        grpDescription.setLayout((Layout)new GridLayout(1, false));
        grpDescription.setText("Description");
        this.descriptionLabel = new Label((Composite)grpDescription, 64);
        this.descriptionLabel.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        return container;
    }

    protected void performDefaults() {
        Map pref = this.manager.getSimpleConfiguration(null, IConfigurationManager.Scope.WORKSPACE, PREF_ID, true);
        if (pref != null) {
            this.prefs = pref;
        }
        this.checkboxTableViewer.refresh(true);
        super.performDefaults();
    }

    public boolean performOk() {
        try {
            this.manager.saveSimpleConfiguration(this.prefs, null, IConfigurationManager.Scope.WORKSPACE, PREF_ID);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return super.performOk();
    }

    public void init(IWorkbench workbench) {
    }
}

