/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.reqcycle.traceability.builder.impl;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import java.util.LinkedList;
import java.util.List;
import org.polarsys.reqcycle.traceability.builder.ITraceabilityBuilder;
import org.polarsys.reqcycle.traceability.model.TType;
import org.polarsys.reqcycle.uri.model.ProxyResolver;
import org.polarsys.reqcycle.uri.model.Reachable;

public class ProxyResolutionBuilderCallbackWrapper
implements ITraceabilityBuilder.IBuilderCallBack {
    private final ITraceabilityBuilder.IBuilderCallBack callBack;
    private final ProxyResolveFunction proxyResolverFunction;

    public ProxyResolutionBuilderCallbackWrapper(ITraceabilityBuilder.IBuilderCallBack callBack, ProxyResolver proxyResolver) {
        this.callBack = callBack;
        this.proxyResolverFunction = new ProxyResolveFunction(proxyResolver);
    }

    @Override
    public boolean needsBuild(Reachable reachable) {
        return this.callBack.needsBuild(reachable);
    }

    @Override
    public void startBuild(Reachable reachable) {
        this.callBack.startBuild(reachable);
    }

    @Override
    public void endBuild(Reachable reachable) {
        this.callBack.endBuild(reachable);
    }

    @Override
    public void errorOccurs(Reachable reachable, Throwable t) {
        this.callBack.errorOccurs(reachable, t);
    }

    @Override
    public void newUpwardRelation(Object traceabilityObject, Object resource, Object source, List<? extends Object> targets, TType label) {
        Object newSource = this.proxyResolverFunction.apply(source);
        LinkedList newTargets = new LinkedList(Collections2.transform(targets, (Function)this.proxyResolverFunction));
        this.callBack.newUpwardRelation(traceabilityObject, resource, newSource, newTargets, label);
    }

    private static final class ProxyResolveFunction
    implements Function<Object, Object> {
        private final ProxyResolver proxyResolver;

        public ProxyResolveFunction(ProxyResolver proxyResolver) {
            this.proxyResolver = proxyResolver;
        }

        public Object apply(Object arg0) {
            return this.proxyResolver.resolve(arg0);
        }
    }
}

