/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.reqcycle.emf.handlers;

import com.google.common.base.Function;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Iterators;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import javax.inject.Singleton;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.polarsys.reqcycle.emf.handlers.IEMFProxyRegistry;
import org.polarsys.reqcycle.emf.utils.EMFUtils;

@Singleton
public class EMFProxyRegistry
implements IEMFProxyRegistry {
    Map<URI, Long> stamps = Maps.newHashMap();
    Cache<URI, Set<String>> cache = CacheBuilder.newBuilder().expireAfterAccess(5L, TimeUnit.MINUTES).build();

    @Override
    public boolean isProxy(URI uri) {
        if (!uri.isPlatformResource()) {
            throw new IllegalArgumentException("not a platform resource");
        }
        final URI path = uri.trimFragment();
        final IFile f = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(path.toPlatformString(true)));
        Long timestamp = this.stamps.get(path);
        if (timestamp == null) {
            timestamp = -1L;
        }
        if (f != null && timestamp != null && timestamp.longValue() != f.getLocalTimeStamp()) {
            this.cache.invalidate((Object)path);
        }
        if (!f.exists()) {
            this.cache.invalidate((Object)path);
        }
        try {
            Collection eobject = (Collection)this.cache.get((Object)path, (Callable)new Callable<Set<String>>(){

                @Override
                public Set<String> call() throws Exception {
                    Resource r = EMFUtils.getFAURSWithPathMaps().getResource(path, true);
                    if (r == null) {
                        return Sets.newHashSet();
                    }
                    Iterator eobjects = Iterators.transform((Iterator)r.getAllContents(), (Function)new Function<EObject, String>(){

                        public String apply(EObject arg0) {
                            return arg0.eResource().getURIFragment(arg0);
                        }
                    });
                    EMFProxyRegistry.this.stamps.put(path, f.getLocalTimeStamp());
                    return Sets.newHashSet((Iterator)eobjects);
                }
            });
            return !eobject.contains(uri.fragment());
        }
        catch (ExecutionException e) {
            e.printStackTrace();
            return false;
        }
    }
}

