/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.reqcycle.traceability.ui.views;

import java.util.regex.Pattern;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CheckboxCellEditor;
import org.eclipse.jface.viewers.ComboBoxViewerCellEditor;
import org.eclipse.jface.viewers.ICellEditorValidator;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.views.properties.PropertyDescriptor;
import org.polarsys.reqcycle.traceability.types.ITraceabilityAttributesManager;
import org.polarsys.reqcycle.traceability.types.configuration.typeconfiguration.AttributeType;

public class LinkPropertyDescriptor
extends PropertyDescriptor {
    private ITraceabilityAttributesManager.EditableAttribute att;
    private static Pattern INTPATTERN = Pattern.compile("-?\\d*");

    public LinkPropertyDescriptor(ITraceabilityAttributesManager.EditableAttribute att) {
        super((Object)att.getName(), att.getName());
        this.att = att;
    }

    public CellEditor createPropertyEditor(Composite parent) {
        if (this.att.getType() == AttributeType.BOOLEAN) {
            return new CheckboxCellEditor(parent);
        }
        Object[] possibleValues = this.att.getPossibleValues();
        if (possibleValues != null && possibleValues.length > 0) {
            ComboBoxViewerCellEditor cellEditor = new ComboBoxViewerCellEditor(parent, 8);
            cellEditor.setContentProvider((IStructuredContentProvider)ArrayContentProvider.getInstance());
            cellEditor.setInput((Object)possibleValues);
            return cellEditor;
        }
        TextCellEditor result = new TextCellEditor(parent);
        if (this.att.getType() == AttributeType.INT) {
            result = new TextCellEditor(parent){

                public Object doGetValue() {
                    return Integer.parseInt((String)super.doGetValue());
                }

                public void doSetValue(Object value) {
                    super.doSetValue((Object)value.toString());
                }
            };
            result.setValidator(new ICellEditorValidator(){

                public String isValid(Object value) {
                    if (value instanceof String && INTPATTERN.matcher((CharSequence)value).matches()) {
                        return null;
                    }
                    return "integer value expected";
                }
            });
        }
        return result;
    }
}

