/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.reqcycle.traceability.ui;

import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.graphics.Image;
import org.polarsys.reqcycle.uri.IReachableManager;
import org.polarsys.reqcycle.uri.exceptions.IReachableHandlerException;
import org.polarsys.reqcycle.uri.model.IReachableHandler;
import org.polarsys.reqcycle.uri.model.Reachable;
import org.polarsys.reqcycle.uri.model.ReachableObject;
import org.polarsys.reqcycle.utils.inject.ZigguratInject;

public class TraceabilityUtils {
    public static String getText(Reachable r) {
        ILabelProvider provider = TraceabilityUtils.getProvider(r);
        if (provider != null) {
            return provider.getText((Object)r);
        }
        return r.toString();
    }

    public static ILabelProvider getProvider(Reachable r) {
        IReachableManager manager = (IReachableManager)ZigguratInject.make(IReachableManager.class);
        try {
            IReachableHandler handler = manager.getHandlerFromReachable(r);
            ReachableObject reachableObject = handler.getFromReachable(r);
            if (reachableObject != null) {
                ILabelProvider provider = (ILabelProvider)reachableObject.getAdapter(ILabelProvider.class);
                return provider;
            }
        }
        catch (IReachableHandlerException iReachableHandlerException) {}
        return null;
    }

    public static Image getImage(Reachable r) {
        ILabelProvider provider = TraceabilityUtils.getProvider(r);
        if (provider != null) {
            return provider.getImage((Object)r);
        }
        return null;
    }
}

