/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.reqcycle.traceability.table.menus.actions;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.ui.dialogs.WorkspaceResourceDialog;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.model.BaseWorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.progress.UIJob;
import org.polarsys.reqcycle.traceability.table.model.TableController;

public class ExplicitLinksAction
extends Action {
    private TableViewer viewer;
    private TableController control;
    protected static ILabelProvider labelProvider = new WorkbenchLabelProvider(){

        public Color getForeground(Object element) {
            return Display.getDefault().getSystemColor(2);
        }

        public Color getBackground(Object element) {
            return Display.getDefault().getSystemColor(1);
        }
    };
    protected static ViewerFilter projectFilter = new ViewerFilter(){

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            return element instanceof IProject;
        }
    };

    public ExplicitLinksAction(TableViewer viewer, TableController control) {
        this.setText("Transverse links");
        this.setToolTipText("Select the project from which transverse links should will be retrieved");
        this.viewer = viewer;
        this.control = control;
    }

    public void run() {
        Shell shell = this.viewer.getTable().getShell();
        BaseWorkbenchContentProvider contentProvider = new BaseWorkbenchContentProvider();
        WorkspaceResourceDialog dialog = new WorkspaceResourceDialog(shell, labelProvider, (ITreeContentProvider)contentProvider);
        dialog.setTitle("Project selection");
        dialog.setMessage("Select the project from which transverse links will be retrieved");
        dialog.addFilter(projectFilter);
        dialog.setAllowMultiple(false);
        dialog.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
        dialog.setValidator(new ISelectionStatusValidator(){

            public IStatus validate(Object[] selection) {
                if (selection.length == 1 && selection[0] instanceof IProject) {
                    return Status.OK_STATUS;
                }
                return new Status(4, "org.polarsys.reqcycle.traceability.table", "Select a project");
            }
        });
        int open = dialog.open();
        if (open == 0) {
            IContainer[] selectedContainers = dialog.getSelectedContainers();
            final IProject project = (IProject)selectedContainers[0];
            new UIJob(Display.getCurrent(), "Fetching traceability links"){

                public IStatus runInUIThread(IProgressMonitor monitor) {
                    monitor.beginTask("Fetching traceability links", 100);
                    ExplicitLinksAction.this.control.displayExplicitLinks(project);
                    return Status.OK_STATUS;
                }
            }.schedule();
        }
    }
}

