/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.reqcycle.traceability.types.configuration.preferences;

import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.widgets.Composite;
import org.polarsys.reqcycle.traceability.types.configuration.preferences.AbstractPreferencePage;
import org.polarsys.reqcycle.traceability.types.configuration.preferences.dialogs.NewCustomTypeDialog;
import org.polarsys.reqcycle.traceability.types.configuration.preferences.providers.PreferenceDialogTypeLabelProvider;
import org.polarsys.reqcycle.traceability.types.configuration.preferences.providers.PreferenceDialogTypesContentProvider;
import org.polarsys.reqcycle.traceability.types.configuration.typeconfiguration.CustomType;
import org.polarsys.reqcycle.traceability.types.configuration.typeconfiguration.Type;
import org.polarsys.reqcycle.traceability.types.configuration.typeconfiguration.TypeConfigContainer;
import org.polarsys.reqcycle.types.IType;
import org.polarsys.reqcycle.types.ITypesManager;
import org.polarsys.reqcycle.utils.inject.ZigguratInject;

public class ElementTypeConfigurationPage
extends AbstractPreferencePage {
    private PreferenceDialogTypesContentProvider preferenceDialogTypesContentProvider;

    @Override
    protected void addAction() {
        Type type;
        IType javaType;
        IStructuredSelection selec;
        if (this.treeViewer.getSelection() instanceof IStructuredSelection && (selec = (IStructuredSelection)this.treeViewer.getSelection()).getFirstElement() instanceof Type && (javaType = (type = (Type)selec.getFirstElement()).getIType()) != null && javaType.isExtensible()) {
            NewCustomTypeDialog d = new NewCustomTypeDialog(this.getShell(), type);
            ZigguratInject.inject((Object[])new Object[]{d});
            if (d.open() == 0) {
                CustomType custom = d.getCustomType();
                this.container.getTypes().add((Object)custom);
            }
        }
    }

    @Override
    protected boolean removeCondition(EObject firstElement) {
        return firstElement instanceof CustomType;
    }

    @Override
    protected String getAddLabel() {
        return "extend";
    }

    @Override
    protected void addDefaultButton(Composite composite_1) {
    }

    @Override
    protected IContentProvider getContentProvider() {
        this.preferenceDialogTypesContentProvider = new PreferenceDialogTypesContentProvider((AdapterFactory)this.factory, this.container);
        ZigguratInject.inject((Object[])new Object[]{this.preferenceDialogTypesContentProvider});
        return this.preferenceDialogTypesContentProvider;
    }

    @Override
    protected ILabelProvider getLabelProvider() {
        PreferenceDialogTypeLabelProvider provider = new PreferenceDialogTypeLabelProvider((AdapterFactory)this.factory, super.getLabelProvider());
        ZigguratInject.inject((Object[])new Object[]{provider});
        return provider;
    }

    public static boolean isExtensible(Type type, ITypesManager manager) {
        IType javaType = null;
        if (!(type instanceof CustomType)) {
            javaType = type.getIType();
        }
        return javaType != null && javaType.isExtensible();
    }

    @Override
    protected ViewerFilter getFilter() {
        return new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                return element instanceof TypeConfigContainer || element instanceof Type;
            }
        };
    }

    @Override
    protected void setInput() {
        if (this.preferenceDialogTypesContentProvider != null) {
            this.preferenceDialogTypesContentProvider.setTypeConfigContainer(this.container);
        }
        this.treeViewer.setInput((Object)this.container.eResource());
    }

    @Override
    protected void selectionChanged(SelectionChangedEvent event) {
        IStructuredSelection struc;
        if (event.getSelection() instanceof IStructuredSelection && (struc = (IStructuredSelection)event.getSelection()).getFirstElement() instanceof Type) {
            Type type = (Type)struc.getFirstElement();
            if (ElementTypeConfigurationPage.isExtensible(type, this.typesManager)) {
                this.btnAdd.setEnabled(true);
            } else {
                this.btnAdd.setEnabled(false);
            }
            this.btnRemove.setEnabled(this.removeCondition((EObject)type));
        }
    }

    @Override
    protected void addProperties(Composite composite) {
    }

    @Override
    protected void removeAction() {
        IStructuredSelection new_name;
        EObject firstElement;
        if (this.treeViewer.getSelection() instanceof IStructuredSelection && this.removeCondition(firstElement = (EObject)(new_name = (IStructuredSelection)this.treeViewer.getSelection()).getFirstElement())) {
            EcoreUtil.delete((EObject)firstElement, (boolean)true);
        }
    }
}

