/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.reqcycle.traceability.builder.impl;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Set;
import org.polarsys.reqcycle.traceability.builder.IBuildingDecoration;
import org.polarsys.reqcycle.traceability.builder.ITraceabilityBuilder;
import org.polarsys.reqcycle.traceability.builder.impl.ExtensionPointReader;
import org.polarsys.reqcycle.traceability.model.TType;
import org.polarsys.reqcycle.uri.model.Reachable;

public class DelegatedAndDecoratedBuilderCallBack
implements ITraceabilityBuilder.IBuilderCallBack {
    ITraceabilityBuilder.IBuilderCallBack callBack = null;
    Set<IBuildingDecoration> decorations = new ExtensionPointReader().read();

    public DelegatedAndDecoratedBuilderCallBack(ITraceabilityBuilder.IBuilderCallBack callBack) {
        this.callBack = callBack;
    }

    @Override
    public boolean needsBuild(Reachable reachable) {
        return this.callBack.needsBuild(reachable);
    }

    @Override
    public void startBuild(Reachable reachable) {
        for (IBuildingDecoration d : this.decorations) {
            d.startBuild(this, reachable);
        }
        this.callBack.startBuild(reachable);
    }

    @Override
    public void endBuild(Reachable reachable) {
        for (IBuildingDecoration d : this.decorations) {
            d.endBuild(this, reachable);
        }
        this.callBack.endBuild(reachable);
    }

    @Override
    public void newUpwardRelation(Object traceability, Object resource, Object source, List<? extends Object> targets, TType kind) {
        String check = "arguments must be different to null";
        Preconditions.checkNotNull((Object)resource, (Object)check);
        Preconditions.checkNotNull((Object)source, (Object)check);
        Preconditions.checkNotNull(targets, (Object)check);
        Preconditions.checkNotNull((Object)kind, (Object)check);
        boolean keepOriginalLink = true;
        for (IBuildingDecoration d : this.decorations) {
            keepOriginalLink &= d.newUpwardRelation(this, traceability, resource, source, targets, kind);
        }
        if (keepOriginalLink) {
            IBuildingDecoration.Composite c = this.getComposite(traceability, resource, source, targets, kind);
            this.callBack.newUpwardRelation(c.traceabilityObject, c.resource, c.source, c.targets, c.kind);
        }
    }

    private IBuildingDecoration.Composite getComposite(Object traceabilityObject, Object resource, Object source, List<? extends Object> targets, TType kind) {
        IBuildingDecoration.Composite compo = new IBuildingDecoration.Composite();
        compo.traceabilityObject = traceabilityObject;
        compo.resource = resource;
        compo.source = source;
        compo.targets = targets;
        compo.kind = kind;
        for (IBuildingDecoration d : this.decorations) {
            try {
                IBuildingDecoration.Composite old = (IBuildingDecoration.Composite)compo.clone();
                d.transform(compo);
                if (compo != null && compo.traceabilityObject != null && compo.kind != null && compo.resource != null && compo.source != null && compo.targets != null) continue;
                compo = old;
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {}
        }
        return compo;
    }

    @Override
    public void errorOccurs(Reachable reachable, Throwable t) {
        for (IBuildingDecoration d : this.decorations) {
            d.errorOccurs(this, reachable, t);
        }
        this.callBack.errorOccurs(reachable, t);
    }
}

