/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.reqcycle.traceability.types.engine.functions;

import com.google.common.base.Function;
import java.util.LinkedList;
import org.polarsys.reqcycle.traceability.engine.ITraceabilityEngine;
import org.polarsys.reqcycle.traceability.model.Link;
import org.polarsys.reqcycle.traceability.model.Pair;
import org.polarsys.reqcycle.traceability.model.TType;
import org.polarsys.reqcycle.traceability.types.RelationBasedType;
import org.polarsys.reqcycle.traceability.types.RelationUtils;
import org.polarsys.reqcycle.traceability.types.configuration.typeconfiguration.Configuration;
import org.polarsys.reqcycle.traceability.types.configuration.typeconfiguration.Relation;
import org.polarsys.reqcycle.uri.model.Reachable;

public class Link2RegisteredLink
implements Function<Pair<Link, Reachable>, Iterable<Pair<Link, Reachable>>> {
    private Configuration typeConfig;
    private ITraceabilityEngine.DIRECTION direction;

    public Link2RegisteredLink(Configuration typeConfig, ITraceabilityEngine.DIRECTION direction) {
        this.typeConfig = typeConfig;
        this.direction = direction;
    }

    public Iterable<Pair<Link, Reachable>> apply(Pair<Link, Reachable> arg0) {
        Link link = (Link)arg0.getFirst();
        TType type = link.getKind();
        Reachable source = (Reachable)((Link)arg0.getFirst()).getSources().iterator().next();
        Reachable target = (Reachable)((Link)arg0.getFirst()).getTargets().iterator().next();
        Iterable<Relation> relations = RelationUtils.getAgregatingRelations(type, this.typeConfig, source, target, this.direction);
        LinkedList<Pair<Link, Reachable>> result = new LinkedList<Pair<Link, Reachable>>();
        for (Relation r : relations) {
            result.add((Pair<Link, Reachable>)new Pair((Object)new Link(link.getId(), (TType)new RelationBasedType(r, type), source, target), (Object)target));
        }
        return result;
    }
}

