/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.reqcycle.traceability.cache.storagebased.engine;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.eclipse.core.runtime.Plugin;
import org.polarsys.reqcycle.core.ILogger;
import org.polarsys.reqcycle.traceability.cache.AbstractCachedTraceabilityEngine;
import org.polarsys.reqcycle.traceability.cache.Activator;
import org.polarsys.reqcycle.traceability.cache.storagebased.engine.pickers.GetTraceabilityPicker;
import org.polarsys.reqcycle.traceability.engine.ITraceabilityEngine;
import org.polarsys.reqcycle.traceability.model.Link;
import org.polarsys.reqcycle.traceability.model.Pair;
import org.polarsys.reqcycle.traceability.model.StopCondition;
import org.polarsys.reqcycle.traceability.model.TType;
import org.polarsys.reqcycle.traceability.model.scopes.ResourceScope;
import org.polarsys.reqcycle.traceability.storage.IStorageProvider;
import org.polarsys.reqcycle.traceability.storage.ITraceabilityStorage;
import org.polarsys.reqcycle.uri.exceptions.IReachableHandlerException;
import org.polarsys.reqcycle.uri.model.IReachableHandler;
import org.polarsys.reqcycle.uri.model.Reachable;
import org.polarsys.reqcycle.uri.model.ReachableObject;
import org.polarsys.reqcycle.utils.inject.ZigguratInject;
import org.polarsys.reqcycle.utils.iterators.exceptions.PickerExecutionException;
import org.polarsys.reqcycle.utils.iterators.factories.IteratorFactory;
import org.polarsys.reqcycle.utils.iterators.pickers.IPicker;

@Singleton
public class StorageBasedTraceabilityEngine
extends AbstractCachedTraceabilityEngine {
    public static final String REVISION = "revisionProperty";
    private Map<Reachable, String> inMemoryRevision = Maps.newHashMap();
    @Inject
    ILogger logger;
    @Inject
    IStorageProvider storageEngine;
    ITraceabilityStorage storage;
    private boolean isDebugging;

    protected void environmentClosed() {
        if (this.isDebugging) {
            this.logger.trace("Storage is closing");
        }
        this.storage.save();
        if (this.isDebugging) {
            this.logger.trace("Storage closed, saved : " + this.getCachePath());
        }
    }

    @PostConstruct
    public void postConstruct() {
        this.isDebugging = this.logger.isDebug("org.polarsys.reqcycle.traceability.cache/debug", (Plugin)Activator.getDefault());
        if (this.isDebugging) {
            this.logger.trace("Storage Initialization");
        }
        this.storage = this.storageEngine.getStorage(this.getCachePath());
        if (this.isDebugging) {
            this.logger.trace("Storage is initialized");
        }
    }

    protected Iterator<Pair<Link, Reachable>> doGetTraceability(Reachable source, ITraceabilityEngine.DIRECTION direction, Predicate<Pair<Link, Reachable>> scope) {
        GetTraceabilityPicker picker = new GetTraceabilityPicker(direction, this.storage, scope);
        ZigguratInject.inject((Object[])new Object[]{picker});
        IPicker[] pickers = new IPicker[]{picker};
        IteratorFactory factory = new IteratorFactory(Arrays.asList(pickers));
        factory.activateDepthWisdom();
        factory.activateRedundancyAwareness();
        Iterator iterator = factory.createIterable((Object)source).iterator();
        iterator.next();
        ArrayList list = Lists.newArrayList((Iterator)Iterators.transform(iterator, (Function)new Function<Object, Pair<Link, Reachable>>(){

            public Pair<Link, Reachable> apply(Object o) {
                return (Pair)o;
            }
        }));
        return list.iterator();
    }

    protected Iterator<Pair<Link, Reachable>> doGetOneLevelTraceability(Reachable source, ITraceabilityEngine.DIRECTION direction, Predicate<Pair<Link, Reachable>> scope) {
        GetTraceabilityPicker picker = new GetTraceabilityPicker(direction, this.storage, scope);
        try {
            Iterable nexts = picker.getNexts(source);
            Iterator iterator = Iterators.transform(nexts.iterator(), (Function)new Function<Object, Pair<Link, Reachable>>(){

                public Pair<Link, Reachable> apply(Object o) {
                    return (Pair)o;
                }
            });
            return iterator;
        }
        catch (PickerExecutionException e) {
            e.printStackTrace();
            return Iterators.emptyIterator();
        }
    }

    protected Iterator<Pair<Link, Reachable>> doGetTraceability(Reachable source, StopCondition condition, ITraceabilityEngine.DIRECTION direction, Predicate<Pair<Link, Reachable>> scope) {
        LinkedHashSet<? extends Pair<Link, Reachable>> result = new LinkedHashSet<Pair<Link, Reachable>>();
        HashSet<Reachable> visited = new HashSet<Reachable>();
        if (source != null && condition != null) {
            GetTraceabilityPicker picker = new GetTraceabilityPicker(direction, this.storage, scope);
            ZigguratInject.inject((Object[])new Object[]{picker});
            result.addAll(this.search(source, condition, picker, visited));
        }
        return result.iterator();
    }

    private List<? extends Pair<Link, Reachable>> search(Reachable source, StopCondition condition, IPicker picker, Set<Reachable> visited) {
        LinkedList<Object> result = new LinkedList<Object>();
        if (!visited.contains(source)) {
            visited.add(source);
            try {
                Pair pair;
                Iterable nexts = picker.getNexts((Object)source);
                for (Object o : nexts) {
                    if (!(o instanceof Pair) || !condition.apply(pair = (Pair)o)) continue;
                    result.add(pair);
                }
                for (Object o : nexts) {
                    List<? extends Pair<Link, Reachable>> tmp;
                    if (!(o instanceof Pair) || (tmp = this.search((Reachable)(pair = (Pair)o).getSecond(), condition, picker, visited)).isEmpty()) continue;
                    result.add(pair);
                    result.addAll(tmp);
                }
            }
            catch (PickerExecutionException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    protected Iterable<Reachable> getEntriesFor(Reachable reachable) {
        return this.storage.getTraceabilityLinksContainedIn(reachable);
    }

    protected void tagDeletedRelationShips(Iterable<Link> linksToTag) {
    }

    public Iterable<Link> getLinksForTraceable(Reachable reachable) {
        return null;
    }

    protected boolean isCacheOk(Reachable reachable) {
        Reachable fromStorage;
        String revision;
        if (reachable == null) {
            return false;
        }
        String uri = ResourceScope.getURIPath((Reachable)reachable.trimFragment());
        if (uri == null) {
            return false;
        }
        Reachable trimmedFragment = reachable.trimFragment();
        String revisionOfObject = null;
        try {
            IReachableHandler handler = this.manager.getHandlerFromReachable(reachable);
            ReachableObject object = handler.getFromReachable(reachable);
            if (object != null) {
                revisionOfObject = object.getRevisionIdentification();
            }
        }
        catch (IReachableHandlerException e) {
            e.printStackTrace();
        }
        if ((revision = this.inMemoryRevision.get(trimmedFragment)) == null && (fromStorage = this.storage.getReachable(trimmedFragment.toString())) != null) {
            revision = fromStorage.get(REVISION);
            this.inMemoryRevision.put(trimmedFragment, revision);
        }
        if (revision != null && revisionOfObject != null) {
            return revision.equals(revisionOfObject);
        }
        return false;
    }

    public void newUpwardRelation(Reachable traceaReachable, Reachable container, Reachable source, List<Reachable> targets, TType tType) {
        this.handleRevision(container);
        this.storage.addOrUpdateUpwardRelationShip(tType, traceaReachable, container, source, targets.toArray(new Reachable[targets.size()]));
    }

    private void handleRevision(Reachable container) {
        String val = container.get("optionCheckCache");
        if (val == null || Boolean.TRUE.equals(val)) {
            IReachableHandler uriHandler = null;
            try {
                uriHandler = this.manager.getHandlerFromReachable(container);
                ReachableObject object = uriHandler.getFromReachable(container);
                if (object != null) {
                    String revision = object.getRevisionIdentification();
                    container.put(REVISION, revision);
                    this.inMemoryRevision.put(container, revision);
                }
            }
            catch (IReachableHandlerException e) {
                e.printStackTrace();
            }
        }
    }

    public void startBuild(Reachable reachable) {
        this.storage.startTransaction();
        this.storage.clearInContainer(reachable);
        super.startBuild(reachable);
    }

    public void endBuild(Reachable reachable) {
        if (reachable == null) {
            return;
        }
        super.endBuild(reachable);
        this.handleRevision(reachable);
        String revision = reachable.get(REVISION);
        this.storage.addUpdateProperty(reachable, REVISION, revision);
        this.inMemoryRevision.put(reachable, revision);
        this.storage.commit();
    }

    public void errorOccurs(Reachable reachable, Throwable t) {
        super.errorOccurs(reachable, t);
        this.storage.rollback();
    }

    protected Iterator<Pair<Link, Reachable>> doGetAllTraceability(ITraceabilityEngine.DIRECTION direction, Predicate<Pair<Link, Reachable>> requestPredicate) {
        return Iterables.filter((Iterable)this.storage.getAllTraceability(direction), requestPredicate).iterator();
    }

    protected void removeTraceabilityLink(Reachable r) {
        this.storage.removeTraceabilityLink(r);
    }
}

