/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.eval.evaluators;

import org.eclipse.jdt.core.dom.CastExpression;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.wb.core.eval.AstEvaluationEngine;
import org.eclipse.wb.core.eval.EvaluationContext;
import org.eclipse.wb.core.eval.IExpressionEvaluator;
import org.eclipse.wb.internal.core.utils.ast.AstNodeUtils;

public final class CastEvaluator
implements IExpressionEvaluator {
    @Override
    public Object evaluate(EvaluationContext context, Expression expression, ITypeBinding typeBinding, String typeQualifiedName) throws Exception {
        if (expression instanceof CastExpression) {
            CastExpression castExpression = (CastExpression)expression;
            Object value = AstEvaluationEngine.evaluate(context, castExpression.getExpression());
            if (castExpression.getType().isPrimitiveType()) {
                Number number = (Number)value;
                String name = AstNodeUtils.getFullyQualifiedName(castExpression.getType(), true);
                if ("byte".equals(name)) {
                    return number.byteValue();
                }
                if ("short".equals(name)) {
                    return number.shortValue();
                }
                if ("char".equals(name)) {
                    return Character.valueOf((char)number.intValue());
                }
                if ("int".equals(name)) {
                    return number.intValue();
                }
                if ("long".equals(name)) {
                    return number.longValue();
                }
                if ("float".equals(name)) {
                    return Float.valueOf(number.floatValue());
                }
                if ("double".equals(name)) {
                    return number.doubleValue();
                }
            }
            return value;
        }
        return AstEvaluationEngine.UNKNOWN;
    }
}

