/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.phpunit.ui.view;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.php.phpunit.model.elements.PHPUnitElement;
import org.eclipse.php.phpunit.model.elements.PHPUnitTestEvent;
import org.eclipse.php.phpunit.model.elements.PHPUnitTestException;
import org.eclipse.php.phpunit.model.elements.PHPUnitTraceFrame;
import org.eclipse.php.phpunit.model.providers.PHPUnitTestDiffTreeContentProvider;
import org.eclipse.php.phpunit.ui.view.DiffLabelProvider;
import org.eclipse.php.phpunit.ui.view.PHPUnitView;
import org.eclipse.php.phpunit.ui.view.actions.OpenEditorAction;
import org.eclipse.php.phpunit.ui.view.actions.OpenEditorAtLineAction;
import org.eclipse.php.phpunit.ui.view.actions.OpenTestAction;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;

public class DiffTrace
implements IMenuListener {
    private PHPUnitElement fInput;
    private PHPUnitView fTestRunner;
    private TreeViewer fTreeViewer;

    public DiffTrace(Composite parent, PHPUnitView testRunner) {
        this.fTreeViewer = new TreeViewer(parent, 772);
        this.fTreeViewer.setAutoExpandLevel(-1);
        this.fTestRunner = testRunner;
        this.fTreeViewer.setLabelProvider((IBaseLabelProvider)new DiffLabelProvider());
        CopyListener copyListener = new CopyListener();
        this.fTreeViewer.getTree().addKeyListener((KeyListener)copyListener);
        this.initMenu();
    }

    Composite getComposite() {
        return this.fTreeViewer.getTree();
    }

    public PHPUnitElement getFailedTest() {
        return this.fInput;
    }

    public PHPUnitElement getTrace() {
        return this.fInput;
    }

    private void initMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener((IMenuListener)this);
        Menu menu = menuMgr.createContextMenu((Control)this.fTreeViewer.getTree());
        this.fTreeViewer.getTree().setMenu(menu);
    }

    public void menuAboutToShow(IMenuManager manager) {
        IStructuredSelection selection = (IStructuredSelection)this.fTreeViewer.getSelection();
        if (!selection.isEmpty()) {
            PHPUnitElement test = (PHPUnitElement)selection.getFirstElement();
            String fileName = test.getLocalFile();
            int lineNumber = test.getLine();
            String methodName = null;
            if (test instanceof PHPUnitTraceFrame) {
                methodName = ((PHPUnitTraceFrame)test).getFunction();
            }
            String openLabel = OpenEditorAction.GOTO_FILE;
            if (test instanceof PHPUnitTraceFrame) {
                openLabel = OpenEditorAction.GOTO_CALL;
            } else if (test instanceof PHPUnitTestEvent) {
                openLabel = OpenEditorAction.GOTO_OCCURANCE;
            }
            manager.add((IAction)new OpenEditorAtLineAction(openLabel, this.fTestRunner, fileName, lineNumber, methodName));
            if (test instanceof PHPUnitTestException) {
                manager.add((IAction)new OpenTestAction(OpenEditorAction.GOTO_CLASS, this.fTestRunner, ((PHPUnitTestException)test).getExceptionClass(), fileName, lineNumber));
            }
            if (test instanceof PHPUnitTraceFrame) {
                PHPUnitTraceFrame frame = (PHPUnitTraceFrame)test;
                String className = frame.getClassName();
                if (className != null && !className.equals("")) {
                    manager.add((IAction)new OpenTestAction(OpenEditorAction.GOTO_CLASS, this.fTestRunner, className, null, 0, null));
                    manager.add((IAction)new OpenTestAction(OpenEditorAction.GOTO_METHOD, this.fTestRunner, className, null, 0, methodName));
                } else {
                    manager.add((IAction)new OpenTestAction(OpenEditorAction.GOTO_FUNCTION, this.fTestRunner, null, null, 0, methodName));
                }
            }
        }
    }

    public void refresh() {
        this.showFailure(this.fInput);
    }

    public void showFailure(PHPUnitElement failure) {
        this.fTreeViewer.setContentProvider((IContentProvider)new PHPUnitTestDiffTreeContentProvider());
        this.fTreeViewer.setInput((Object)failure);
        this.fInput = failure;
        this.fTreeViewer.refresh();
        this.fTreeViewer.expandAll();
    }

    private void copyPressed() {
        IContentProvider contentProvider = this.fTreeViewer.getContentProvider();
        if (contentProvider instanceof PHPUnitTestDiffTreeContentProvider) {
            Clipboard cb = new Clipboard(Display.getDefault());
            TextTransfer textTransfer = TextTransfer.getInstance();
            String diff = ((PHPUnitTestDiffTreeContentProvider)contentProvider).getDiff();
            cb.setContents(new Object[]{diff}, new Transfer[]{textTransfer});
        }
    }

    private final class CopyListener
    extends SelectionAdapter
    implements KeyListener {
        private CopyListener() {
        }

        public void keyPressed(KeyEvent event) {
            if (!((event.stateMask & 0x40000) != 262144 && (event.stateMask & 0x400000) != 0x400000 || event.keyCode != 99 && event.keyCode != 67)) {
                DiffTrace.this.copyPressed();
            }
        }

        public void keyReleased(KeyEvent arg0) {
        }
    }
}

