/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.editor.actions.errors;

import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.internal.core.DesignerPlugin;
import org.eclipse.wb.internal.core.editor.Messages;
import org.eclipse.wb.internal.core.editor.actions.errors.IErrorPage;
import org.eclipse.wb.internal.core.editor.errors.JavaExceptionComposite;
import org.eclipse.wb.internal.core.editor.errors.report2.CreateReportDialog;
import org.eclipse.wb.internal.core.editor.errors.report2.ZipFileErrorReport;
import org.eclipse.wb.internal.core.utils.exception.DesignerExceptionUtils;
import org.eclipse.wb.internal.core.utils.execution.ExecutionUtils;
import org.eclipse.wb.internal.core.utils.execution.RunnableEx;
import org.eclipse.wb.internal.core.utils.ui.GridDataFactory;
import org.eclipse.wb.internal.core.utils.ui.GridLayoutFactory;
import org.eclipse.wb.internal.core.utils.ui.dialogs.ResizableTitleAreaDialog;

public final class ErrorsDialog
extends ResizableTitleAreaDialog {
    private static final int CONTACT_SUPPORT_ID = 999;
    private final ObjectInfo m_rootObject;
    private final List<IErrorPage> m_pages;
    private final Dialog m_dialog;
    private final Image m_screenshot;

    public ErrorsDialog(Shell parentShell, ObjectInfo rootObject, List<IErrorPage> pages) {
        super(parentShell, (AbstractUIPlugin)DesignerPlugin.getDefault());
        this.m_rootObject = rootObject;
        this.m_pages = pages;
        this.m_screenshot = DesignerExceptionUtils.makeScreenshot();
        JavaInfo rootObjectJava = this.m_rootObject instanceof JavaInfo ? (JavaInfo)this.m_rootObject : null;
        ICompilationUnit unit = rootObject != null ? rootObjectJava.getEditor().getModelUnit() : null;
        IProject project = unit != null ? unit.getJavaProject().getProject() : null;
        ZipFileErrorReport errorReport = new ZipFileErrorReport(this.m_screenshot, project, JavaExceptionComposite.getSourceFileReport(unit));
        this.m_dialog = new CreateReportDialog(DesignerPlugin.getShell(), this.m_screenshot, errorReport);
    }

    protected final Control createContents(Composite parent) {
        Control control = super.createContents(parent);
        this.configureMessages();
        return control;
    }

    protected void configureMessages() {
        this.getShell().setText(Messages.ErrorsDialog_shellTitle);
        this.setTitle(Messages.ErrorsDialog_title);
        this.setMessage(Messages.ErrorsDialog_message);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 999, Messages.ErrorsDialog_supportButton, false);
        this.createButton(parent, 12, IDialogConstants.CLOSE_LABEL, true);
    }

    protected Control createDialogArea(Composite parent) {
        Composite area = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(area, 0);
        GridDataFactory.create((Control)container).grab().fill();
        GridLayoutFactory.create((Composite)container);
        TabFolder tabFolder = new TabFolder(container, 0);
        GridDataFactory.create((Control)tabFolder).grab().fill();
        for (IErrorPage page : this.m_pages) {
            page.setRoot(this.m_rootObject);
            TabItem tabItem = new TabItem(tabFolder, 0);
            tabItem.setText(page.getTitle());
            Control pageControl = page.create((Composite)tabFolder);
            tabItem.setControl(pageControl);
        }
        return area;
    }

    protected void buttonPressed(int buttonId) {
        this.close();
        if (999 == buttonId) {
            ExecutionUtils.runLogLater((RunnableEx)new RunnableEx(){

                public void run() throws Exception {
                    ErrorsDialog.this.handleContactSupport();
                }
            });
        }
    }

    private void handleContactSupport() {
        this.m_dialog.open();
    }

    public boolean close() {
        boolean success = super.close();
        if (success && this.m_screenshot != null) {
            this.m_screenshot.dispose();
        }
        return success;
    }
}

