/*
 * Decompiled with CFR 0.152.
 */
package io.github.toolfactory.jvm.function.catalog;

import io.github.toolfactory.jvm.function.catalog.GetDeclaredFieldsFunction;
import io.github.toolfactory.jvm.function.template.ThrowingBiFunction;
import io.github.toolfactory.jvm.util.ObjectProvider;
import io.github.toolfactory.jvm.util.Strings;
import java.lang.reflect.Field;
import java.util.Map;

public interface GetDeclaredFieldFunction
extends ThrowingBiFunction<Class<?>, String, Field, Throwable> {

    public static class ForJava7
    implements GetDeclaredFieldFunction {
        protected GetDeclaredFieldsFunction getDeclaredFields;

        public ForJava7(Map<Object, Object> context) {
            ObjectProvider functionProvider = ObjectProvider.get(context);
            this.getDeclaredFields = functionProvider.getOrBuildObject(GetDeclaredFieldsFunction.class, context);
        }

        @Override
        public Field apply(Class<?> cls, String name) throws Throwable {
            for (Field field : (Field[])this.getDeclaredFields.apply(cls)) {
                if (!field.getName().equals(name)) continue;
                return field;
            }
            throw new NoSuchFieldException(Strings.compile("Field named {} not found in the class {}", name, cls.getName()));
        }
    }
}

