/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.digester3.binder;

import org.apache.commons.digester3.ObjectCreateRule;
import org.apache.commons.digester3.binder.AbstractBackToLinkedRuleBuilder;
import org.apache.commons.digester3.binder.LinkedRuleBuilder;
import org.apache.commons.digester3.binder.RulesBinder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ObjectCreateBuilder
extends AbstractBackToLinkedRuleBuilder<ObjectCreateRule> {
    private final ClassLoader classLoader;
    private Class<?> type;
    private String attributeName;

    ObjectCreateBuilder(String keyPattern, String namespaceURI, RulesBinder mainBinder, LinkedRuleBuilder mainBuilder, ClassLoader classLoader) {
        super(keyPattern, namespaceURI, mainBinder, mainBuilder);
        this.classLoader = classLoader;
    }

    public ObjectCreateBuilder ofType(String className) {
        if (className == null) {
            this.reportError("createObject().ofType( String )", "NULL Java type not allowed");
            return this;
        }
        try {
            return this.ofType(this.classLoader.loadClass(className));
        }
        catch (ClassNotFoundException e) {
            this.reportError("createObject().ofType( String )", String.format("class '%s' cannot be load", className));
            return this;
        }
    }

    public <T> ObjectCreateBuilder ofType(Class<T> type) {
        if (type == null) {
            this.reportError("createObject().ofType( Class<?> )", "NULL Java type not allowed");
            return this;
        }
        this.type = type;
        return this;
    }

    public ObjectCreateBuilder ofTypeSpecifiedByAttribute(String attributeName) {
        this.attributeName = attributeName;
        return this;
    }

    @Override
    protected ObjectCreateRule createRule() {
        return new ObjectCreateRule(this.attributeName, this.type);
    }
}

