/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.analysis.profiling.core.callstack.provider;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.analysis.profiling.core.callstack.CallStackAnalysis;
import org.eclipse.tracecompass.internal.analysis.profiling.core.callstack.provider.CallStackDataProvider;
import org.eclipse.tracecompass.internal.analysis.profiling.core.callstack.provider.Messages;
import org.eclipse.tracecompass.internal.tmf.core.model.DataProviderDescriptor;
import org.eclipse.tracecompass.internal.tmf.core.model.timegraph.TmfTimeGraphCompositeDataProvider;
import org.eclipse.tracecompass.tmf.core.dataprovider.IDataProviderDescriptor;
import org.eclipse.tracecompass.tmf.core.dataprovider.IDataProviderFactory;
import org.eclipse.tracecompass.tmf.core.model.tree.ITmfTreeDataModel;
import org.eclipse.tracecompass.tmf.core.model.tree.ITmfTreeDataProvider;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceManager;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceUtils;
import org.eclipse.tracecompass.tmf.core.trace.experiment.TmfExperiment;

public class CallStackDataProviderFactory
implements IDataProviderFactory {
    private static final IDataProviderDescriptor DESCRIPTOR = new DataProviderDescriptor.Builder().setId("org.eclipse.tracecompass.internal.analysis.profiling.callstack.provider.CallStackDataProvider").setName(Objects.requireNonNull(Messages.CallStackDataProviderFactory_title)).setDescription(Objects.requireNonNull(Messages.CallStackDataProviderFactory_descriptionText)).setProviderType(IDataProviderDescriptor.ProviderType.TIME_GRAPH).build();

    public @Nullable ITmfTreeDataProvider<? extends ITmfTreeDataModel> createProvider(ITmfTrace trace) {
        if (trace instanceof TmfExperiment) {
            @NonNull ArrayList<@NonNull CallStackDataProvider> providers = new ArrayList<CallStackDataProvider>();
            for (ITmfTrace child : TmfTraceManager.getTraceSet((ITmfTrace)trace)) {
                CallStackDataProvider provider = CallStackDataProviderFactory.createProviderLocal(child);
                if (provider == null) continue;
                providers.add(provider);
            }
            if (providers.size() == 1) {
                return (ITmfTreeDataProvider)providers.get(0);
            }
            if (!providers.isEmpty()) {
                return new TmfTimeGraphCompositeDataProvider(providers, "org.eclipse.tracecompass.internal.analysis.profiling.callstack.provider.CallStackDataProvider");
            }
            return null;
        }
        return CallStackDataProviderFactory.createProviderLocal(trace);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public Collection<IDataProviderDescriptor> getDescriptors(@NonNull ITmfTrace trace) {
        @NonNull Iterable modules = TmfTraceUtils.getAnalysisModulesOfClass((ITmfTrace)trace, CallStackAnalysis.class);
        return !Iterables.isEmpty((Iterable)modules) ? Collections.singletonList(DESCRIPTOR) : Collections.emptyList();
    }

    private static @Nullable CallStackDataProvider createProviderLocal(@NonNull ITmfTrace trace) {
        Iterator modules = TmfTraceUtils.getAnalysisModulesOfClass((ITmfTrace)trace, CallStackAnalysis.class).iterator();
        if (modules.hasNext()) {
            CallStackAnalysis first = (CallStackAnalysis)modules.next();
            first.schedule();
            return new CallStackDataProvider(trace, first);
        }
        return null;
    }
}

