/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.debug.core.pdi.request;

import org.eclipse.osgi.util.NLS;
import org.eclipse.ptp.debug.core.TaskSet;
import org.eclipse.ptp.debug.core.pdi.IPDIDebugger;
import org.eclipse.ptp.debug.core.pdi.PDIException;
import org.eclipse.ptp.debug.core.pdi.request.IPDIEventRequest;
import org.eclipse.ptp.internal.debug.core.pdi.messages.Messages;

public abstract class AbstractEventRequest
implements IPDIEventRequest {
    protected int status = 5;
    protected TaskSet tasks = null;
    protected String message = "";

    public AbstractEventRequest(TaskSet tasks) {
        this.tasks = tasks.copy();
    }

    @Override
    public void cancel() {
        try {
            this.doFinish();
            this.status = 4;
        }
        catch (PDIException e) {
            this.error(e.getMessage());
        }
    }

    @Override
    public boolean completed(TaskSet cTasks, Object result) {
        this.tasks.andNot(cTasks);
        return this.tasks.isEmpty();
    }

    @Override
    public void done() {
        try {
            this.doFinish();
            this.status = 3;
        }
        catch (PDIException e) {
            this.error(e.getMessage());
        }
    }

    @Override
    public void error(String message) {
        this.status = 1;
        this.message = message;
        try {
            this.doFinish();
        }
        catch (PDIException e) {
            this.message = String.valueOf(this.message) + " - " + e.getMessage();
        }
    }

    @Override
    public void execute(IPDIDebugger debugger) {
        try {
            this.doExecute(debugger);
        }
        catch (PDIException e) {
            this.error(e.getMessage());
        }
    }

    @Override
    public String getErrorMessage() {
        return this.message;
    }

    @Override
    public int getResponseAction() {
        return 1;
    }

    @Override
    public int getStatus() {
        return this.status;
    }

    @Override
    public TaskSet getTasks() {
        return this.tasks;
    }

    @Override
    public void setStatus(int status) {
        this.status = status;
    }

    public String toString() {
        String statusStr = Messages.AbstractEventRequest_0;
        switch (this.status) {
            case 1: {
                statusStr = Messages.AbstractEventRequest_1;
                break;
            }
            case 2: {
                statusStr = Messages.AbstractEventRequest_2;
                break;
            }
            case 3: {
                statusStr = Messages.AbstractEventRequest_3;
                break;
            }
            case 4: {
                statusStr = Messages.AbstractEventRequest_4;
            }
        }
        return NLS.bind((String)Messages.AbstractEventRequest_5, (Object[])new Object[]{this.getName(), statusStr, this.getTasks()});
    }

    protected abstract void doExecute(IPDIDebugger var1) throws PDIException;

    protected abstract void doFinish() throws PDIException;
}

