/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wildwebdeveloper.eslint;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.eclipse.lsp4e.LanguageClientImpl;
import org.eclipse.lsp4j.ConfigurationItem;
import org.eclipse.lsp4j.ConfigurationParams;
import org.eclipse.wildwebdeveloper.eslint.ESLintLanguageServerExtension;

public class ESLintClientImpl
extends LanguageClientImpl
implements ESLintLanguageServerExtension {
    @Override
    public CompletableFuture<Integer> confirmESLintExecution(Object param) {
        return CompletableFuture.completedFuture(4);
    }

    public CompletableFuture<List<Object>> configuration(ConfigurationParams configurationParams) {
        ConfigurationItem configurationItem = (ConfigurationItem)configurationParams.getItems().get(0);
        HashMap<String, Object> config = new HashMap<String, Object>(6, 1.0f);
        File highestPackageJsonDir = null;
        try {
            File parentFile = highestPackageJsonDir = new File(new URI(configurationItem.getScopeUri())).getParentFile();
            while (parentFile != null) {
                if (new File(parentFile, "package.json").exists()) {
                    highestPackageJsonDir = parentFile;
                }
                parentFile = parentFile.getParentFile();
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        config.put("workspaceFolder", Collections.singletonMap("uri", highestPackageJsonDir.toURI().toString()));
        config.put("workingDirectory", Collections.singletonMap("mode", "auto"));
        config.put("nodePath", highestPackageJsonDir.getAbsolutePath());
        config.put("validate", "on");
        config.put("run", "onType");
        config.put("codeAction", Map.of("disableRuleComment", Map.of("enable", "true", "location", "separateLine"), "showDocumentation", Collections.singletonMap("enable", "true")));
        return CompletableFuture.completedFuture(Collections.singletonList(config));
    }

    @Override
    public CompletableFuture<Void> eslintStatus(Object o) {
        return CompletableFuture.completedFuture(null);
    }
}

